<?php
/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.5.1
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;
$post_thumbnail_id = $product->get_image_id();
$image = wp_get_attachment_image($post_thumbnail_id, 'woocommerce_gallery_thumbnail', true, array("class" => "main_thumbnails_product_image woocommerce-product-gallery__image"));
$attachment_ids = $product->get_gallery_image_ids();

// product image layout
$image_layout = (rt_option('woocommerce_single_gallery', 'left-gallery') == 'left-gallery' && rt_option('woocommerce_single_layout', 'normal') == 'normal') ? 'vertical' : 'horizontal';
$image_position = (rt_option('woocommerce_single_gallery', 'left-gallery') == 'left-gallery' && rt_option('woocommerce_single_layout', 'normal') == 'normal') ? false : true;

?>

<?php if($attachment_ids):?>

<div class="js-product-thumbnails rt-product-gallery__thumbnails woocommerce-product-gallery__wrapper rt-swiper swiper-container" data-direction="<?php echo esc_attr($image_layout)?>" data-position="<?php echo esc_attr($image_position)?>">
	<div class="swiper-wrapper">

		<div class="swiper-slide main_product_thumbnail">
			<?php 
			if(!empty($post_thumbnail_id)){
				echo $image;
			}
			?>
		</div>

		<?php foreach ( $attachment_ids as $key => $attachment_id ): ?>
			<div class="swiper-slide">
				<?php echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', wc_get_gallery_image_html( $attachment_id ), $attachment_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped ?>
			</div>
		<?php endforeach ?>
		
	</div>

	<div class="swiper-button-prev"></div>
    <div class="swiper-button-next"></div>

</div>

<?php endif ?>