<?php
/**
 * Order Item Details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details-item.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 5.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! apply_filters( 'woocommerce_order_item_visible', true, $item ) ) {
	return;
}
?>
<tr class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'woocommerce-table__line-item order_item', $item, $order ) ); ?>">

	<td class="woocommerce-table__product-name product-name" colspan="2" style="padding-top: 0 !important; padding-bottom: 0 !important">
		<?php
			$is_visible        = $product && $product->is_visible();
			$product_permalink = apply_filters( 'woocommerce_order_item_permalink', $is_visible ? $product->get_permalink( $item ) : '', $item, $order );
			
			?>

			<div class="rt-cart-item">
				<div class="rt-cart-item__thumbnail rt-img rt-img-full">
					<?php echo wp_get_attachment_image(get_post_thumbnail_id( $item['product_id'])); ?>
				</div>
				<div class="rt-cart-item__body">
					<h5 class="rt-cart-item__title">
						<?php echo apply_filters('woocommerce_order_item_name', $product_permalink ? sprintf('<a href="%s">%s</a>', $product_permalink, $item->get_name()) : $item->get_name(), $item, $is_visible);?>
					</h5>
					<div class="rt-cart-item__meta">
						<?php echo __('Qty:', 'woocommerce').' '.apply_filters( 'woocommerce_order_item_quantity_html', $item->get_quantity(), $item ); ?>
						<?php do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order, false ); ?>
						<?php wc_display_item_meta( $item ); ?>
						<?php do_action('woocommerce_order_item_meta_end', $item_id, $item, $order, false);?>
					</div>
					<div class="rt-cart-item__price">
						<?php echo $order->get_formatted_line_subtotal( $item ); ?>
					</div>
				</div>
				
			</div>

		
	</td>


</tr>

<?php if ( $show_purchase_note && $purchase_note ) : ?>

<tr class="woocommerce-table__product-purchase-note product-purchase-note">

	<td colspan="2"><?php echo wpautop( do_shortcode( wp_kses_post( $purchase_note ) ) ); ?></td>

</tr>

<?php endif; ?>
