<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 *  
 * Retheme 1.0.0 - Overridden
 * To do:
 * - added new DOM product
 * - remove default hook
 * - added individual hook
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

?>
<div id="<?php echo 'product-'.get_the_id() ?>" <?php rt_shop_product_class($product ); ?>>

 <?php 
	 /**
	 * Hook: woocommerce_before_shop_loop_item.
	 *
	 * @hooked woocommerce_template_loop_product_link_open - 10 remove
	 */
	do_action( 'woocommerce_before_shop_loop_item' );
	?>

 	<div class="rt-product__thumbnail">
 		<a href="<?php the_permalink(); ?>">
 			<span class="rt-product__overlay"></span>
 			<?php
               /**
				 * Hook: woocommerce_before_shop_loop_item_title.
				 *
				 * @hooked woocommerce_show_product_loop_sale_flash - 10
				 * @hooked woocommerce_template_loop_product_thumbnail - 10
				 */
				do_action('woocommerce_before_shop_loop_item_title');

            ?>
 		</a>

 	</div>

 	<div class="rt-product__body">

		<h3 class="rt-product__title">
			<a href="<?php the_permalink(); ?>"> 
				<?php rt_the_title(rt_option('shop_title_limit_string')) ?>
			</a>
		</h3>

		<?php 
		/**
		 * Hook: woocommerce_after_shop_loop_item_title.
		 *
		 * @hooked woocommerce_template_loop_rating - 5
		 * @hooked woocommerce_template_loop_price - 10
		 */
		do_action('woocommerce_after_shop_loop_item_title');
		?>

 	</div>

	 <?php 
	 /**
	 * Hook: woocommerce_after_shop_loop_item.
	 *
	 * @hooked woocommerce_template_loop_product_link_close - 5 remove
	 * @hooked woocommerce_template_loop_add_to_cart - 10
	 */
	do_action( 'woocommerce_after_shop_loop_item' );
	?>
</div>