<?php
if (get_the_category() && rt_single_option('related')) {

    $terms = get_the_terms(get_the_ID(), 'category');
    $query_related = array();

    if (!is_wp_error($terms) && !empty($terms)) {

        foreach ($terms as $key => $term) {
            $term_id[] = $term->term_id;
        }

        if ($term_id) {
            $query_related['tax_query'][] = array(
                'taxonomy' => 'category',
                'field' => 'term_id',
                'terms' => $term_id,
                'operator' => 'IN',
            );
        }
    }

    $results = array_merge($query_related, array(
        'id' => 'post_related',
        'class' => 'rt-swiper--card',
        'post__not_in' => array(get_the_ID()),
        'post_type' => 'post',
        'posts_per_page' => rt_option('single_related_count', 6),
        'carousel' => true,
        'template_part' => 'template-parts/single/related-content',
        'slider_item' => rt_option('single_related_show', 3),
        'slider_item_tablet' => rt_option('single_related_show_tablet', 2),
        'slider_item_mobile' => rt_option('single_related_show_mobile', 2),
    ));


    if (count(get_posts($results))) {
        echo rt_header_block([
            "title" => __("You also like", RT_THEME_DOMAIN),
        ]);

        rt_template_loop($results);
    }

}
