<?php
if (is_admin() && rt_option('block_preview', false)) {
    rt_block_editor_preview(['title' => 'Image Slider']);
    return false;
}

$slider_args = array(
    "id" => "rt-block-slider-{$block['id']}",
    'items-lg' => rt_get_block_field("slider_show", 4),
    'items-md' => rt_get_block_field("slider_show_tablet", 3),
    'items-sm' => rt_get_block_field("slider_show_mobile", 1),
    'nav' => true,
    'pagination' => [
        'el' => '.swiper-pagination',
        'clickable' => true,
    ],
    'loop' => rt_get_block_field('slider_loop', false),
    'autoplay' => rt_get_block_field('slider_autoplay', false),

);

$slides = rt_get_field('slides', false, true);
?>

<?php if($slides): ?>
    <?php echo rt_before_slider(wp_parse_args(['class' => 'rt-swiper--rounded'], $slider_args)); ?>
    <?php foreach ($slides as $key => $slide): ?>
        <div class="swiper-slide">

            <?php if (!empty($slide['url'])): ?><a href="<?php echo esc_url($slide['url']) ?>"><?php endif?>

            <div class="rt-img rt-img--full">
                <?php echo wp_get_attachment_image($slide['image'], 'full'); ?>
            </div>

            <?php if (!empty($slide['url'])): ?></a><?php endif?>

        </div>
    <?php endforeach;?>
    <?php echo rt_after_slider(); ?>
<?php else: ?>
    <?php if(is_admin()){
        rt_block_editor_preview(['title' => 'Image Slider']);
    } ?>
<?php endif ?>