<?php
if (is_admin() && rt_option('block_preview', false)) {
    rt_block_editor_preview(['title' => 'Product Categories']);
    return false;
}

// category
$terms = get_terms(array(
    'taxonomy' => 'product_cat',
    'hide_empty' => rt_get_block_field('hide_empty', false),
));
?>

<?php  
if(rt_get_block_field('style', 'style-1') == 'style-1'){
    echo rt_before_slider([
        'id' => "rt-block-product-categories-{$block['id']}",
        'items-lg' => rt_get_block_field('slider_show', 3),
        'items-md' => rt_get_block_field('slider_show_tablet', 2),
        'items-sm' => rt_get_block_field('slider_show_mobile', 2),
        "slider_loop" => rt_get_block_field("slider_loop", false),
        "slider_auto_play" => rt_get_block_field("slider_autoplay", false),
        "slider_gap" => 20,
    ]);
}else{
    echo rt_before_slider([
        'id' => "rt-block-product-categories-{$block['id']}",
        'items-lg' => 'auto',
        'items-md' => 'auto',
        'items-sm' => 'auto',
        "slider_loop" => rt_get_block_field("slider_loop", false),
        "slider_auto_play" => rt_get_block_field("slider_autoplay", false),
        'centerInsufficientSlides' => true,
        'navigation' => false,
        'pagination' => [
            'el' => '.swiper-pagination',
            'clickable' => true,
        ],
    ]);
    
}
?>

<?php if (!empty($terms) && !is_wp_error($terms)):?>

    <?php foreach ($terms as $key => $term): ?>

        
        <?php if ($term->slug != 'uncategorized'): ?>
        
            <?php $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);?>

            <?php if(rt_get_block_field('style', 'style-1') == 'style-1'): ?>
                
            <div class="swiper-slide">
                <div class="rt-banner mall-0">
                    <a href="<?php echo get_term_link($term->slug, 'product_cat') ?>">

                        <span class="rt-banner__badges"><?php echo wp_sprintf(__('%s items', RT_THEME_DOMAIN), $term->count) ?></span>

                        <div class="rt-banner__thumbnail">
                            <?php
                                if($thumbnail_id){
                                    echo wp_get_attachment_image($thumbnail_id, 'featured_medium');
                                }else{
                                    echo wc_placeholder_img('featured_medium');
                                }
                            ?>
                        </div>
                        <span class="rt-banner__overlay"></span>
                        <div class="rt-banner__body">
                            <h5 class="rt-banner__title"><?php echo esc_html( $term->name ); ?></h5>
                        </div>
                    </a>
                </div>
            </div>
            <?php endif ?>

            <?php if(rt_get_block_field('style', 'style-1') == 'style-2'): ?>
            <div class="swiper-slide" style="width: auto">
                
                <a href="<?php echo get_term_link($term->slug, 'product_cat') ?>">
                    <div class="rt-img-box mall-0">
                        <div class="rt-img-box__thumbnail rt-img rt-img--circle" style="width: 70px">
                            <?php
                            if($thumbnail_id){
                                echo wp_get_attachment_image($thumbnail_id, array('70', '70'));
                            }else{
                                echo wc_placeholder_img('thumbnail');
                            } 
                            ?>
                        </div>

                        <div class="rt-img-box__body">
                            <h5 class="rt-img-box__title"><?php echo $term->name ?></h5>
                            <span class="rt-img-box__meta"><?php echo wp_sprintf(__('%s items', RT_THEME_DOMAIN), $term->count) ?></span>
                        </div>
                    </div>
                </a>
                
            </div>
            <?php endif ?>
                
            
        <?php endif?>
    <?php endforeach?>

<?php endif;?>

<?php echo rt_after_slider(); ?>