<?php

if (is_admin() && rt_option('block_preview', false)) {
    rt_block_editor_preview(['title' => 'Post']);
    return false;
}

rt_template_loop([
    "id" => "rt-block-post-{$block['id']}",
    "class" => 'block-post',
    "post_type" => "post",
    "template_part" => "template-parts/post/post",
    "posts_per_page" => rt_get_block_field("posts_per_page", 8),
    "query_by" => rt_get_block_field("query_by"),
    "category" => rt_get_block_field("category"),
    "post_id" => rt_get_block_field("post_id"),
    "orderby" => rt_get_block_field("orderby"),
    "setting_column" => rt_get_block_field("column", 4),
    "setting_column_tablet" => rt_get_block_field("column_tablet", 3),
    "setting_column_mobile" => rt_get_block_field("column_mobile", 2),
    "pagination_style" => rt_get_block_field("pagination", 'none'),
    "carousel" => rt_get_block_field("carousel"),
    "slider_item" => rt_get_block_field("slider_show", 4),
    "slider_item_tablet" => rt_get_block_field("slider_show_tablet", 3),
    "slider_item_mobile" => rt_get_block_field("slider_show_mobile", 1),
    'slider_gap' => 20,
    "slider_loop" => rt_get_block_field("slider_loop"),
    "slider_auto_play" => rt_get_block_field("slider_autoplay"),
    "slider_link" => rt_get_block_field("slider_link"),
    "link_text" => rt_get_block_field("link_text"),
    "link_url" => rt_get_block_field("link_url"),
]);
