<?php
/*=================================================
 *  WOO COMMERCE SUPPORT
/*================================================= */
function rt_woocommerce_support() {
    add_theme_support('woocommerce');
    add_theme_support('wc-product-gallery-lightbox');
}
add_action('after_setup_theme', 'rt_woocommerce_support');

/*=================================================;
/* SCRIPTS WOOCOMMERCE
/*================================================= */

function rt_woocommerce_scripts() {
    // disable default scripts woocommerce
    wp_dequeue_style('woocommerce-general');
    wp_dequeue_style('woocommerce-layout');

    // add new scripts woocommerce
    wp_enqueue_style('retheme-woo', get_template_directory_uri() . '/assets/css/woocommerce/woocommerce.min.css', false, '1.9.1');
    wp_enqueue_script('retheme-woo', get_template_directory_uri() . '/assets/js/woocommerce/woocommerce.min.js', false, '1.5.1', true);

    // Quantity field
    if (rt_option('woocommerce_archive_style', 'style-1') == 'style-3') {
        wp_enqueue_script('retheme-quantity-field', get_template_directory_uri() . '/assets/js/woocommerce/quantity-field.min.js', array('retheme-woo'), '1.0.0', true);
    }

    // ajax add to cart
    if (rt_is_premium()) {
        wp_enqueue_script('retheme-cart', get_template_directory_uri() . '/assets/js/woocommerce/add-to-cart.min.js', array('jquery'), '1.8.1', true);
    }

    if (rt_is_woocommerce('product')) {
        wp_enqueue_style('retheme-product', get_template_directory_uri() . '/assets/css/woocommerce/product.min.css', false, '1.4.0');
        wp_enqueue_script('retheme-product', get_template_directory_uri() . '/assets/js/woocommerce/product.min.js', array('jquery', 'swiper'), '1.7.0', true);
        wp_enqueue_script('retheme-variation', get_template_directory_uri() . '/assets/js/woocommerce/variation.min.js', array('jquery'), '4.0.0', true);
    }

    if (rt_is_woocommerce('checkout') || rt_is_woocommerce('cart')) {
        wp_enqueue_style('retheme-checkout', get_template_directory_uri() . '/assets/css/woocommerce/checkout.min.css', false, '1.2.0');
        wp_enqueue_script('retheme-checkout', get_template_directory_uri() . '/assets/js/woocommerce/checkout.min.js', false, '1.2.0', true);
    }

    if (rt_is_woocommerce('account')) {
        wp_enqueue_style('retheme-account', get_template_directory_uri() . '/assets/css/woocommerce/account.min.css', false, '1.2.0');
    }
}
add_action('wp_enqueue_scripts', 'rt_woocommerce_scripts', 10);

/*=================================================;
/* REGISTER WIDGET LOCATION
/*================================================= */
function rt_woocommerce_register_widget_location() {

    register_sidebar(array(
        'name' => __('WooCommerce Sidebar', RT_THEME_DOMAIN),
        'id' => 'retheme_woocommerce_sidebar',
        'before_widget' => '<div id="%1$s" class="rt-widget rt-widget--aside %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="rt-widget__header"><h3 class="rt-widget__title">',
        'after_title' => '</h3></div>',
    ));

    register_sidebar(array(
        'name' => __('WooCommerce Filter', RT_THEME_DOMAIN),
        'id' => 'retheme_woocommerce_filter',
        'before_widget' => '<div id="%1$s" class="rt-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="rt-widget__header"><h4 class="rt-widget__title">',
        'after_title' => '</h4></div>',
    ));
}
add_action('widgets_init', 'rt_woocommerce_register_widget_location');

/*=================================================;
/* WOOCOMMERCE - SET TEXT DOMAIN FILE
/*================================================= */
/* Replace 'textdomain' with your plugin's textdomain. e.g. 'woocommerce'.
 * File to be named, for example, yourtranslationfile-en_GB.mo
 * File to be placed, for example, wp-content/languages/textdomain/yourtranslationfile-en_GB.mo
 */
function rt_woocommerce_translation_file($mofile, $domain) {
    if ('woocommerce' === $domain && !function_exists('loco_plugin_file')) {
        $mofile = get_stylesheet_directory() . '/languages/woocommerce-' . get_locale() . '.mo';
    }

    return $mofile;
}
add_filter('load_textdomain_mofile', 'rt_woocommerce_translation_file', 10, 2);

/*=================================================;
/* CATEGORIES COUNT
/*================================================= */
function rt_woocommerce_subcategory_count_html($html, $category) {
    $count = wp_sprintf(__('%s products', RT_THEME_DOMAIN), absint($category->count));
    $html = "<div class='count'>{$count}</div>";
    return $html;
}
add_filter('woocommerce_subcategory_count_html', 'rt_woocommerce_subcategory_count_html', 10, 2);

/*=================================================
 * PRICE CLASS
=================================================== */
function rt_product_price_class($classes) {
    $classes = "product_price {$classes}";

    return $classes;
}
add_filter('woocommerce_product_price_class', 'rt_product_price_class');

/*=================================================;
/* QTY FIELD
/*=================================================
 * Added plus/min icon on product quantity field
 */
function rt_woocommerce_add_before_quantity() {
    if (rt_is_premium()) {
        echo '<div class="rt-qty js-quantity-change">';
        echo '<span class="rt-qty__min minus">-</span>';
    }
}

function rt_woocommerce_add_after_quantity() {
    if (rt_is_premium()) {
        echo '<span class="rt-qty__max plus">+</span>';
        echo '</div>';
    }
}
add_action('woocommerce_before_quantity_input_field', 'rt_woocommerce_add_before_quantity');
add_action('woocommerce_after_quantity_input_field', 'rt_woocommerce_add_after_quantity');



/*=================================================;
/* MOVE STORE NOTIFICATION
/*=================================================
 * move default store notification form footer to header top
 */
remove_action('wp_footer', 'woocommerce_demo_store');
add_action('rt_header', 'woocommerce_demo_store', 1);

/*=================================================;
/* INCLUDE FILE
/*================================================= */
function rt_woocommerce_init() {
    include_once dirname(__FILE__) . '/shop.php';
    include_once dirname(__FILE__) . '/product.php';
    include_once dirname(__FILE__) . '/cart.php';
    include_once dirname(__FILE__) . '/checkout.php';
    include_once dirname(__FILE__) . '/user.php';
}
add_action('woocommerce_init', 'rt_woocommerce_init');
