<?php
/*=================================================;
/* SHOP - FAILED LOGIN REDIRECT
/*================================================= */
// handle user failed login on modal login
// redirect to default login page
function rt_user_woocommerce_login_failed()
{
    $referrer = $_SERVER['HTTP_REFERER'];
    $my_account_page = wc_get_page_permalink('myaccount');
    $checkout_page = wc_get_page_permalink('checkout');

    if (!empty($referrer) &&
        !strstr($referrer, 'wp-login') &&
        !strstr($referrer, 'wp-admin') &&
        !strstr($referrer, $my_account_page) &&
        !strstr($referrer, $checkout_page)) {
        wp_redirect(wc_get_page_permalink('myaccount') . '?login="failed"');
        exit;
    }
}
add_action('woocommerce_login_failed', 'rt_user_woocommerce_login_failed');  

/*=================================================;
/* WOOCOMMERCE - FAILED LOGIN MESSAGE
/*================================================= */
// Send message error if user fail login from modal
// send message on default page login
function rt_user_woocommerce_login_failed_message()
{
    if (!empty($_GET['login']) && $_GET['login'] == 'failed' && !is_user_logged_in()) {
        wc_add_notice(__('Login failed, please check username & password then try again', RT_THEME_DOMAIN), 'error');
    }

}
add_action('wp', 'rt_user_woocommerce_login_failed_message');

/*=================================================;
/* USER - MODAL LOGIN
/*================================================= */
// added login form
function rt_user_modal()
{
    if (!is_user_logged_in()) {
        rt_get_template_part('shop/form-login-modal');
    }
}
add_action('rt_footer', 'rt_user_modal');
