<?php
if (!class_exists('Merlin')) {
    return;
}
/**
 * Set directory locations, text strings, and settings.
 */
class Retheme_Merlin extends Merlin
{
    /**
     * Activate the EDD license.
     *
     * This code was taken from the EDD licensing addon theme example code
     * (`activate_license` method of the `EDD_Theme_Updater_Admin` class).
     *
     * @param string $license The license key.
     *
     * @return array
     */
    protected function edd_activate_license($key)
    {
        $success = false;

        // Strings passed in from the config file.
        $strings = $this->strings;

        // Theme Name.
        $theme = ucfirst($this->theme);

        // Remove "Child" from the current theme name, if it's installed.
        $theme = str_replace(' Child', '', $theme);

        // Text strings.
        $success_message = $strings['license-json-success%s'];

        // API Manager
        $license = New \Retheme\Activation(array(
            'product_extends' => rt_get_theme('extends'),
            'product_key' => $key,
        ));

        $status = $license->activate();
        $message = sprintf(esc_html($status['message']), $theme);

        if ($status['result'] == 'success') {
            $success = true;
        } else {
            $success = false;
        }

        return compact('success', 'message');

    }

}

// set config theme wizard
new Retheme_Merlin(
    $config = array(
        'directory' => 'core/vendor/merlin', // Location / directory where Merlin WP is placed in your theme.
        'merlin_url' => 'merlin', // The wp-admin page slug where Merlin WP loads.
        'parent_slug' => 'themes.php', // The wp-admin parent page slug for the admin menu item.
        'capability' => 'manage_options', // The capability required for this menu to be displayed to the user.
        'child_action_btn_url' => 'https://codex.wordpress.org/child_themes', // URL for the 'child-action-link'.
        'dev_mode' => true, // Enable development mode for testing.
        'license_step' => true, // EDD license activation step.
        'license_required' => false, // Require the license activation step.
        'license_help_url' => '', // URL for the 'license-tooltip'.
        'edd_remote_api_url' => '', // EDD_Theme_Updater_Admin remote_api_url.
        'edd_item_name' => RT_THEME_NAME, // EDD_Theme_Updater_Admin item_name.
        'edd_theme_slug' => RT_THEME_SLUG, // EDD_Theme_Updater_Admin item_slug.
        'ready_big_button_url' => site_url(), // Link for the big button on the ready step.
    ),

    $strings = array(
        'admin-menu' => esc_html__('Theme Setup', RT_THEME_DOMAIN),
        /* translators: 1: Title Tag 2: Theme Name 3: Closing Title Tag */
        'title%s%s%s%s' => esc_html__('%1$s%2$s Themes &lsaquo; Theme Setup: %3$s%4$s', RT_THEME_DOMAIN),
        'return-to-dashboard' => esc_html__('Kembali kehalaman admin', RT_THEME_DOMAIN),
        'ignore' => esc_html__('Matikan fitur wizard', RT_THEME_DOMAIN),
        'btn-skip' => esc_html__('Lewati', RT_THEME_DOMAIN),
        'btn-next' => esc_html__('Selanjutnya', RT_THEME_DOMAIN),
        'btn-start' => esc_html__('Mulai', RT_THEME_DOMAIN),
        'btn-no' => esc_html__('Batal', RT_THEME_DOMAIN),
        'btn-plugins-install' => esc_html__('Instal', RT_THEME_DOMAIN),
        'btn-child-install' => esc_html__('Instal', RT_THEME_DOMAIN),
        'btn-content-install' => esc_html__('Instal', RT_THEME_DOMAIN),
        'btn-import' => esc_html__('Impor', RT_THEME_DOMAIN),
        'btn-license-activate' => esc_html__('Aktifkan', RT_THEME_DOMAIN),
        'btn-license-skip' => esc_html__('Nanti', RT_THEME_DOMAIN),
        /* translators: Theme Name */
        'license-header%s' => esc_html__('Aktifkan %s', RT_THEME_DOMAIN),
        /* translators: Theme Name */
        'license-header-success%s' => esc_html__('%s sudah diaktifkan', RT_THEME_DOMAIN),
        /* translators: Theme Name */
        'license%s' => esc_html__('Masukan kunci lisensi untuk mendapatkan semua fitur premium, update, dan dukungan dari Webforia Studio', RT_THEME_DOMAIN),
        'license-label' => esc_html__('Kunci lisensi', RT_THEME_DOMAIN),
        'license-success%s' => esc_html__('Tema ini sudah terdaftar, silakan lanjutkan ke langkah berikutnya', RT_THEME_DOMAIN),
        'license-json-success%s' => esc_html__('Tema Anda sudah di aktifkan! Fitur Premium, update, dan dukungan bisa digunakan', RT_THEME_DOMAIN),
        'license-tooltip' => esc_html__('Butuh bantuan?', RT_THEME_DOMAIN),
        /* translators: Theme Name */
        'welcome-header%s' => esc_html__('Selamat datang di %s', RT_THEME_DOMAIN),
        'welcome-header-success%s' => esc_html__('Hi. Selamat datang kembali', RT_THEME_DOMAIN),
        'welcome%s' => esc_html__('Fitur Wizard ini akan membantu Anda untuk melakukan pengaturan tema, memasang plugin, dan mengimpor konten. Langkah ini hanya opsional tapi sangat direkomendasikan bagi Anda yang baru di dunia WordPress.', RT_THEME_DOMAIN),
        'welcome-success%s' => esc_html__('Anda mungkin sudah menjalankan fitur Wizard ini sebelumnnya, Jika Anda ingin melanjutkannya silakan klik tombol "Mulai" di bawah ini', RT_THEME_DOMAIN),
        'child-header' => esc_html__('Install tema anak', RT_THEME_DOMAIN),
        'child-header-success' => esc_html__('You\'re good to go!', RT_THEME_DOMAIN),
        'child' => esc_html__('Aktifkan tema anak sehingga Anda dapat dengan mudah melakukan perubahan tanpa merusak tema utama.', RT_THEME_DOMAIN),
        'child-success%s' => esc_html__('Tema anak Anda berhasil di install dan diaktifkan', RT_THEME_DOMAIN),
        'child-action-link' => esc_html__('Pelajari lebih lanjut tentang tema anak', RT_THEME_DOMAIN),
        'child-json-success%s' => esc_html__('Tema anak Anda sudah diinstall dan diaktifkan', RT_THEME_DOMAIN),
        'child-json-already%s' => esc_html__('Tema anak Anda sudah berhasil dibuat dan sekarang sudah diaktifkan', RT_THEME_DOMAIN),
        'plugins-header' => esc_html__('Install Plugins', RT_THEME_DOMAIN),
        'plugins-header-success' => esc_html__('Mengagumkan', RT_THEME_DOMAIN),
        'plugins' => esc_html__('Mari kita instal beberapa plugin WordPress yang dibutuhkan untuk membangun situs Anda.', RT_THEME_DOMAIN),
        'plugins-success%s' => esc_html__('Semua plugin WordPress yang dibutuhkan sudah terpasang dan diperbarui. klik "Selanjutnya" untuk melanjutkan kepengaturan.', RT_THEME_DOMAIN),
        'plugins-action-link' => esc_html__('Tingkat lanjut', RT_THEME_DOMAIN),
        'import-header' => esc_html__('Impor Konten', RT_THEME_DOMAIN),
        'import' => esc_html__('Pilih desain template yang ingin Anda gunakan', RT_THEME_DOMAIN),
        'import-action-link' => esc_html__('Tingkat lanjut', RT_THEME_DOMAIN),
        'ready-header' => esc_html__('Proses installasi selesai. Selamat bersenang-senang!', RT_THEME_DOMAIN),
        /* translators: Theme Author */
        'ready%s' => esc_html__('Tema Anda telah diatur. Nikmati tema baru Anda yang dikembangkan oleh %s.', RT_THEME_DOMAIN),
        'ready-action-link' => esc_html__('Extra', RT_THEME_DOMAIN),
        'ready-big-button' => esc_html__('Kunjungi website', RT_THEME_DOMAIN),
        // 'ready-link-1' => sprintf('<a href="%1$s" target="_blank">%2$s</a>', admin_url( 'index.php?page=wc-setup'), esc_html__('Setup Toko', RT_THEME_DOMAIN)),
        'ready-link-2' => sprintf('<a href="%1$s" target="_blank">%2$s</a>', admin_url('customize.php'), esc_html__('Mulai melakukan kostumisasi', RT_THEME_DOMAIN)),
        'ready-link-3' => sprintf('<a href="%1$s" target="_blank">%2$s</a>', 'https://webforia.id/kontak/', esc_html__('Hubungi dukungan tema', RT_THEME_DOMAIN)),

    )
);

// check license
function merlin_check_license()
{
    return (rt_is_premium())?true:false;
}
add_filter('merlin_is_theme_registered', 'merlin_check_license');
add_filter('wp_ajax_merlin_child_theme', '__return_false'); // disable generate child theme
