<?php
/*=================================================;
/* REGISTER ASSETS
/*================================================= */
function rt_scripts()
{
    // Swiper Js
    wp_enqueue_style('swiper', get_template_directory_uri() . '/assets/swiper/swiper.min.css', false, '5.4.5');
    wp_enqueue_script('swiper', get_template_directory_uri() . '/assets/swiper/swiper.min.js', false, '5.4.5', true);
    wp_enqueue_script('retheme-swiper', get_template_directory_uri() . '/assets/js/retheme-swiper.min.js', ['swiper'], '1.1.0', true);

    // animate css
    wp_enqueue_style('animate', get_template_directory_uri() . '/assets/css/animate.min.css', false, '4.1.2', 'last-load');
    wp_enqueue_script('animate', get_template_directory_uri() . '/assets/js/animate.min.js', false, '1.6.0', true);

    // Masonry
    if (rt_option('blog_archive_masonry', false) || rt_option('woocommerce_archive_masonry', false)) {
        wp_enqueue_style('retheme-masonry', get_template_directory_uri() . '/assets/css/masonry.min.css', false, '1.0.0');
        wp_enqueue_script('masonry', get_template_directory_uri() . '/assets/js/masonry.pkgd.min.js', false, '4.2.2', true);
        wp_enqueue_script('retheme-masonry', get_template_directory_uri() . '/assets/js/retheme-masonry.min.js', ['masonry'], '1.0.0', true);
    }

    // Countdown Timer
    if (rt_option('countdown_timer_shop', true)) {
        wp_enqueue_script('retheme-countdown', get_template_directory_uri() . '/assets/js/countdown.min.js', false, '2.0.0', true);
    }

    // Retheme Base
    wp_enqueue_script('retheme-helper', get_template_directory_uri() . '/assets/js/helper.min.js', false, '1.0.0', true);

    wp_enqueue_style('retheme', get_template_directory_uri() . '/assets/css/retheme.min.css', false, '3.5.0');
    wp_enqueue_script('retheme', get_template_directory_uri() . '/assets/js/main.min.js', ['animate', 'retheme-helper'], '2.7.1', true);

    // Comment
    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_style('retheme-comment', get_template_directory_uri() . '/assets/css/comment.min.css', false, '1.0.0');
        wp_enqueue_script('comment-reply');
    }

}

add_action('wp_enqueue_scripts', 'rt_scripts', 99999);

/*=================================================;
/* LOAD STYLE ON FOOTER
/*================================================= */
function rt_styles_last_load()
{
    $script = 'function scripts_last_load(){document.querySelectorAll("link").forEach(function(t){"last-load"==t.getAttribute("media")&&t.setAttribute("media","all")})}window.addEventListener("load",scripts_last_load);';
    wp_register_script('style_last_load', '', [], '', true);
    wp_enqueue_script('style_last_load');
    wp_add_inline_script('style_last_load', $script);
}
add_action('wp_enqueue_scripts', 'rt_styles_last_load', 1);

/*=================================================;
/* MOVE JQUERY IN FOOTER
/*================================================= */
function rt_script_move_jquery_into_footer($wp_scripts)
{

    if (is_admin()) {
        return;
    }

    if (rt_option('move_jquery_to_footer', true)) {
        $wp_scripts->add_data('jquery', 'group', 1);
        $wp_scripts->add_data('jquery-core', 'group', 1);
        $wp_scripts->add_data('jquery-migrate', 'group', 1);
    }

}
add_action('wp_default_scripts', 'rt_script_move_jquery_into_footer');


/*=================================================;
/* REMOVE EMOJI
/*================================================= */
function rt_script_remove_wp_emoji()
{
    if (is_admin()) {
        return;
    }
    if (rt_option('remove_wp_emoji', true)) {
        remove_action('wp_head', 'print_emoji_detection_script', 7);
        remove_action('admin_print_scripts', 'print_emoji_detection_script');
        remove_action('wp_print_styles', 'print_emoji_styles');
        remove_action('admin_print_styles', 'print_emoji_styles');
    }
}

add_action('after_setup_theme', 'rt_script_remove_wp_emoji');

/*=================================================;
/* DISABLE GUTENBERG BLOCK STYLE ON FRONTEND
/*================================================= */
function rt_script_remove_block_css()
{
    if (is_admin()) {
        return;
    }

    // Global
    if (rt_option('remove_block_style', true)) {
        wp_dequeue_style('wp-block-library'); // Wordpress core
        wp_dequeue_style('wp-block-library-theme'); // Wordpress core
        wp_dequeue_style('global-styles'); // Remove global Gutenberg style inline
    }

    // WooCommerce
    if (rt_option('remove_wc_block_style', true)) {
        wp_dequeue_style('wc-blocks-style');
    }
}
add_action('wp_enqueue_scripts', 'rt_script_remove_block_css', 100);

/*=================================================;
/* DISABLE ELEMENTOR GOOGLE FONTS
/*================================================= */
function rt_remove_elementor_google_fonts()
{
    if (rt_option('remove_elementor_google_font', false)) {
        add_filter('elementor/frontend/print_google_fonts', '__return_false');
    }
}
add_action('init', 'rt_remove_elementor_google_fonts');

/*=================================================;
/* DISABLE
/*================================================= */
function rt_remove_elementor_icons()
{

    if (rt_option('remove_elementor_icon', false)) {
        wp_dequeue_style('elementor-icons');
    }

    if (rt_option('remove_elementor_fontawesome', false)) {
        wp_dequeue_style('font-awesome');
    }
}
add_action('wp_enqueue_scripts', 'rt_remove_elementor_icons', 20);
