<?php
namespace Retheme\Elementor;

use Elementor;
use Elementor\Controls_Manager;
use Retheme\Elementor_Base;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Product_Categories extends Elementor_Base
{
    public function get_name()
    {
        return 'retheme-product-category';
    }

    public function get_title()
    {
        return __('Products Categories', RT_THEME_DOMAIN);
    }

    public function get_icon()
    {
        return 'ate-icon ate-product';

    }

    public function get_categories()
    {
        return ['retheme-elements'];
    }

    protected function register_controls()
    {
        $this->setting_option();
    }

    protected function setting_option()
    {
        $this->start_controls_section(
            'setting_product',
            [
                'label' => __('Options', RT_THEME_DOMAIN),
            ]
        );

        $this->add_control(
            'setting_style',
            [
                'label' => __('Style', RT_THEME_DOMAIN),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-1' => __('Style 1', RT_THEME_DOMAIN),
                    'style-2' => __('Style 2', RT_THEME_DOMAIN),
                ],
                'default' => 'style-1',
            ]
        );

        $this->add_control(
            'setting_empty_category',
            [
                'label' => __('Hide Empty Category', RT_THEME_DOMAIN),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __('On', RT_THEME_DOMAIN),
                'label_off' => __('Off', RT_THEME_DOMAIN),
                'return_value' => 'no',
            ]
        );

        $slides_to_show = range(1, 10);
        $slides_to_show = array_combine($slides_to_show, $slides_to_show);
        $this->add_responsive_control(
            'slider_item',
            [
                'label' => __('Slides Per View', RT_THEME_DOMAIN),
                'type' => Controls_Manager::SELECT,
                'options' => $slides_to_show,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'desktop_default' => 4,
                'tablet_default' => 3,
                'mobile_default' => 1,
                'condition' => [
                    'setting_style!' => 'style-2',
                ],
            ]
        );

        $this->add_control(
            'slider_loop',
            [
                'label' => __('Infinite Loop', RT_THEME_DOMAIN),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_off' => __('Off', RT_THEME_DOMAIN),
                'label_on' => __('On', RT_THEME_DOMAIN),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'slider_auto_play',
            [
                'label' => __('Auto Play', RT_THEME_DOMAIN),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __('On', RT_THEME_DOMAIN),
                'label_off' => __('Off', RT_THEME_DOMAIN),
                'return_value' => 'yes',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();

        include dirname(__FILE__) . '/product-view.php';
    }
}
