<?php
/**
 * @author : Reret
 */
namespace Retheme\Customizer;

use Retheme\Customizer_Base;

class WooCommerce extends Customizer_Base
{

    public function __construct()
    {

        add_action('customize_register', [$this, 'remove_default_field']);

        $this->set_section();

        $this->add_archive_option();
        $this->shop_navbar();
        $this->add_archive_layout();
        $this->add_archive_styles();

        $this->add_single_option();
        $this->add_single_related();
        $this->add_single_layout();

        if (rt_is_premium()) {
            $this->add_sale_badge();
            $this->add_cart();
        }

    }

    public function set_section()
    {
        $this->add_section('woocommerce', [
            'woocommerce_single' => [__('Product Single', RT_THEME_DOMAIN)],
            'woocommerce_badge' => [__('Badge Sale', RT_THEME_DOMAIN)],
            'woocommerce_cart' => [__('Cart', RT_THEME_DOMAIN)],
            'woocommerce_checkout' => [__('Checkout', RT_THEME_DOMAIN)],
            'woocommerce_navbar' => [__('Navbar Shop', RT_THEME_DOMAIN)],
        ]);

    }

    /**
     * Remove default customizer woocommerce
     *
     * @param [type] $wp_customize customizer control
     * @return void
     */
    public function remove_default_field($wp_customize)
    {
        $wp_customize->add_control('woocommerce_catalog_columns')->theme_supports = false;
        $wp_customize->add_control('woocommerce_catalog_rows')->theme_supports = false;
    }

    public function shop_navbar()
    {

        $section = 'woocommerce_navbar_section';
        if (rt_is_premium()) {
            $chooses = [
                'shop' => __('Shop', RT_THEME_DOMAIN),
                'filter' => __('Filters', RT_THEME_DOMAIN),
                'user' => __('User', RT_THEME_DOMAIN),
                'cart' => __('Cart', RT_THEME_DOMAIN),
            ];

            $this->add_field([
                'type' => 'multicheck',
                'settings' => 'woocommerce_shop_navbar_bottom',
                'label' => __('Navbar Bottom', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => [
                    'shop', 'filter', 'user', 'cart',
                ],
                'multiple' => 999,
                'choices' => $chooses,
            ]);
        }
    }

    public function add_archive_option()
    {
        $section = 'woocommerce_product_catalog';
        if (rt_is_premium()) {
            $this->add_field([
                'type' => 'radio-image',
                'settings' => 'woocommerce_archive_style',
                'label' => __('Style', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => 'style-1',
                'choices' => [
                    'style-1' => get_template_directory_uri() . '/core/customizer/assets/img/product-style-1.png',
                    'style-2' => get_template_directory_uri() . '/core/customizer/assets/img/product-style-2.png',
                    'style-3' => get_template_directory_uri() . '/core/customizer/assets/img/product-style-3.png',
                ],
            ]);

            $this->add_field([
                'type' => 'toggle',
                'settings' => 'woocommerce_archive_masonry',
                'description' => __('Grid layout with different height', RT_THEME_DOMAIN),
                'label' => __('Masonry', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => false,
            ]);

            $this->add_field([
                'type' => 'toggle',
                'settings' => 'woocommerce_archive_card',
                'label' => __('Product Card frame', RT_THEME_DOMAIN),
                'description' => __('When enabled, show a border around Product Cards.', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => false,
            ]);

            $this->add_field([
                'type' => 'radio-buttonset',
                'settings' => 'woocommerce_archive_text_align',
                'label' => __('Content Position', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => 'center',
                'choices' => [
                    'left' => '<i class="fas fa-align-left"></i>',
                    'center' => '<i class="fas fa-align-center"></i>',
                    'right' => '<i class="fas fa-align-right"></i>',
                ],
                'transport' => 'auto',
                'output' => [
                    [
                        'exclude' => ['center', 'right'],
                        'element' => '.rt-product__body',
                        'property' => 'text-align',
                        'value_pattern' => 'left',
                    ],
                    [
                        'exclude' => ['left', 'right'],
                        'element' => '.rt-product__body',
                        'property' => 'text-align',
                        'value_pattern' => 'center',
                    ],
                    [
                        'exclude' => ['left', 'center'],
                        'element' => '.rt-product__body',
                        'property' => 'text-align',
                        'value_pattern' => 'right',
                    ],
                    [
                        'exclude' => ['center', 'right'],
                        'element' => '.rt-product .wsb-countdown',
                        'property' => 'justify-content',
                        'value_pattern' => 'left',
                    ],
                    [
                        'exclude' => ['left', 'right'],
                        'element' => '.rt-product__body',
                        'property' => 'justify-content',
                        'value_pattern' => 'center',
                    ],
                    [
                        'exclude' => ['left', 'center'],
                        'element' => '.rt-product__body',
                        'property' => 'justify-content',
                        'value_pattern' => 'right',
                    ],
                ],
            ]);

            $this->add_field_responsive([
                'type' => 'slider',
                'section' => $section,
                'settings' => 'woocommerce_archive_options_column',
                'label' => __('Column', RT_THEME_DOMAIN),
                'description' => __('Number of Column Per Row', RT_THEME_DOMAIN),
                'default' => 3,
                'default_tablet' => 2,
                'default_mobile' => 2,
                'choices' => [
                    'min' => 1,
                    'max' => 6,
                ],

            ]);

            $this->add_field_responsive([
                'type' => 'number',
                'section' => $section,
                'settings' => 'woocommerce_archive_options_post_per_page',
                'label' => __('Products Per Page', RT_THEME_DOMAIN),
                'default' => 9,
                'choices' => [
                    'min' => 1,
                    'max' => 20,
                ],
            ]);

            $this->add_field([
                'type' => 'select',
                'settings' => 'woocommerce_archive_pagination',
                'label' => __('Pagination', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => 'number',
                'multiple' => 1,
                'choices' => [
                    'none' => __('None', RT_THEME_DOMAIN),
                    'number' => __('Number', RT_THEME_DOMAIN),
                    'loadmore' => __('Load More', RT_THEME_DOMAIN),
                ],
            ]);
        }
    }

    public function add_archive_layout()
    {
        $section = 'woocommerce_product_catalog';

        $this->add_header([
            'label' => __('Product Archive Layout', RT_THEME_DOMAIN),
            'settings' => 'woocommerce_archive_layout',
            'section' => $section,
        ]);
        $this->add_field([
            'type' => 'radio-image',
            'settings' => 'woocommerce_archive_layout',
            'label' => __('Layout', RT_THEME_DOMAIN),
            'description' => sprintf(__('Visit the <a href="%s">Widgets panel</a> and add widget to display a element in a sidebar shop or filter.', RT_THEME_DOMAIN), "javascript:wp.customize.panel( 'widgets' ).focus();"),
            'section' => $section,
            'default' => 'sidebar-right',
            'choices' => [
                'normal' => get_template_directory_uri() . '/core/customizer/assets/img/layout-normal.png',
                'compact' => get_template_directory_uri() . '/core/customizer/assets/img/layout-compact.png',
                'sidebar-left' => get_template_directory_uri() . '/core/customizer/assets/img/layout-sidebar-left.png',
                'sidebar-right' => get_template_directory_uri() . '/core/customizer/assets/img/layout-sidebar-right.png',
            ],
        ]);
    }

    public function add_single_option()
    {
        $section = 'woocommerce_single_section';

        if (rt_is_premium()) {
            $this->add_field([
                'type' => 'radio-image',
                'settings' => 'woocommerce_single_gallery',
                'label' => __('Image Gallery thumbnails', RT_THEME_DOMAIN),
                'description' => __('Choose the layout for thumbnails of images uploaded into the products', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => 'left-gallery',
                'choices' => [
                    'left-gallery' => get_template_directory_uri() . '/core/customizer/assets/img/gallery-left.png',
                    'bottom-gallery' => get_template_directory_uri() . '/core/customizer/assets/img/gallery-bottom.png',
                ],

                'active_callback' => [
                    [
                        'setting' => 'woocommerce_single_layout',
                        'operator' => '==',
                        'value' => 'normal',
                    ],

                ],
            ]);

            $this->add_field([
                'type' => 'toggle',
                'label' => __('Product Meta', RT_THEME_DOMAIN),
                'settings' => 'woocommerce_single_meta',
                'section' => $section,
                'default' => true,
            ]);

            $this->add_field([
                'type' => 'toggle',
                'label' => __('Share Button', RT_THEME_DOMAIN),
                'settings' => 'woocommerce_single_share',
                'section' => $section,
                'default' => true,
            ]);

            $this->add_field([
                'type' => 'toggle',
                'label' => __('Related Product', RT_THEME_DOMAIN),
                'settings' => 'woocommerce_single_product_related',
                'section' => $section,
                'default' => true,
            ]);

            $this->add_field([
                'type' => 'toggle',
                'label' => __('Unique Header On Mobile', RT_THEME_DOMAIN),
                'description' => __('Product Header like native mobile app', RT_THEME_DOMAIN),
                'settings' => 'header_product',
                'section' => $section,
                'default' => true,
            ]);
        }

    }

    public function add_single_related()
    {
        $section = 'woocommerce_single_section';

        $this->add_header([
            'label' => 'Related Product',
            'settings' => 'woocommerce_single_related',
            'section' => $section,
            'active_callback' => [
                [
                    'setting' => 'woocommerce_single_product_related',
                    'operator' => '==',
                    'value' => true,
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'number',
            'settings' => 'woocommerce_single_related_count',
            'label' => __('Total Number of Related Products', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => 6,
            'active_callback' => [
                [
                    'setting' => 'woocommerce_single_product_related',
                    'operator' => '==',
                    'value' => true,
                ],
            ],
        ]);

        $this->add_field_responsive([
            'type' => 'slider',
            'section' => $section,
            'settings' => 'woocommerce_single_related_show',
            'label' => __('Slides Per View', RT_THEME_DOMAIN),
            'default' => 4,
            'default_tablet' => 2,
            'default_mobile' => 2,
            'choices' => [
                'min' => 1,
                'max' => 6,
            ],
            'active_callback' => [
                [
                    'setting' => 'woocommerce_single_product_related',
                    'operator' => '==',
                    'value' => true,
                ],
            ],

        ]);

    }

    public function add_single_layout()
    {
        $section = 'woocommerce_single_section';

        $this->add_header([
            'label' => 'Product Single Layout',
            'settings' => 'woocommerce_single_layout',
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'radio-image',
            'settings' => 'woocommerce_single_layout',
            'label' => __('Layout', RT_THEME_DOMAIN),
            'description' => sprintf(__('Visit the <a href="%s">Widgets panel</a> and add widget to display a element in a sidebar shop or filter.', RT_THEME_DOMAIN), "javascript:wp.customize.panel( 'widgets' ).focus();"),
            'section' => $section,
            'default' => 'normal',
            'choices' => [
                'normal' => get_template_directory_uri() . '/core/customizer/assets/img/layout-normal.png',
                'compact' => get_template_directory_uri() . '/core/customizer/assets/img/layout-compact.png',
                'sidebar-left' => get_template_directory_uri() . '/core/customizer/assets/img/layout-sidebar-left.png',
                'sidebar-right' => get_template_directory_uri() . '/core/customizer/assets/img/layout-sidebar-right.png',
            ],
        ]);
    }

/**
 * sale badge in image thumbnail
 *
 * @return void
 */
    public function add_sale_badge()
    {
        if (rt_is_premium()) {
            $this->add_field_color([
                'settings' => 'woocommerce_sale',
                'section' => 'woocommerce_badge_section',
                'element' => '.woocommerce span.onsale',
            ]);

            $this->add_field_background([
                'settings' => 'woocommerce_sale_background',
                'section' => 'woocommerce_badge_section',
                'element' => '.woocommerce span.onsale',
            ]);

            $this->add_field_border_color([
                'settings' => 'woocommerce_sale_border_color',
                'section' => 'woocommerce_badge_section',
                'element' => '.woocommerce span.onsale',
            ]);

        }
    }

    public function add_cart()
    {
        $section = 'woocommerce_cart_section';

        $this->add_field([
            'type' => 'select',
            'settings' => 'woocommerce_cart_behavior',
            'section' => $section,
            'label' => __('Add to cart behaviour', RT_THEME_DOMAIN),
            'default' => 'ajax_addtocart_panel',
            'priority' => 1,
            'choices' => [
                'default' => 'Default WooCommerce',
                'ajax_addtocart_panel' => 'Ajax Add To Cart',
                'keep_on_page' => 'Keep On Page',
                'redirect_checkout' => 'Redirect to checkout Page',
                'catalog' => 'Catalog (without button)',
            ],
        ]);
    }

    public function add_archive_styles()
    {

        if (rt_is_advanced()) {
            $section = 'woocommerce_product_catalog';

            $this->add_header([
                'label' => __('Styles', RT_THEME_DOMAIN),
                'settings' => 'woocommerce_advanced_style',
                'section' => $section,
                'active_callback' => [
                    [
                        'setting' => 'woocommerce_archive_card',
                        'operator' => '==',
                        'value' => true,
                    ],
                ],
            ]);

            $this->add_field([
                'settings' => 'woocommerce_archive_card_background',
                'type' => 'color',
                'label' => __('Content Background', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => '',
                'output' => [
                    [
                        'element' => '.rt-product.rt-product--card',
                        'property' => 'background-color',
                    ],
                ],
                'transport' => 'auto',
                'active_callback' => [
                    [
                        'setting' => 'woocommerce_archive_card',
                        'operator' => '==',
                        'value' => true,
                    ],
                ],
            ]);

            $this->add_field([
                'settings' => 'woocommerce_title_color',
                'type' => 'color',
                'label' => __('Title Color', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => '',
                'output' => [
                    [
                        'element' => '.rt-product__title a:not(:hover)',
                        'property' => 'color',
                    ],
                ],
                'transport' => 'auto',
                'active_callback' => [
                    [
                        'setting' => 'woocommerce_archive_card',
                        'operator' => '==',
                        'value' => true,
                    ],
                ],
            ]);

            $this->add_field([
                'settings' => 'woocommerce_price_color',
                'type' => 'color',
                'label' => __('Price Color', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => '',
                'output' => [
                    [
                        'element' => '.rt-product span.price',
                        'property' => 'color',
                    ],
                ],
                'transport' => 'auto',
                'active_callback' => [
                    [
                        'setting' => 'woocommerce_archive_card',
                        'operator' => '==',
                        'value' => true,
                    ],
                ],
            ]);

        }
    }

// end class
}

new WooCommerce;
