<?php

/**
 * @author : Reret
 */

namespace Retheme\Customizer;

use Retheme\Customizer_Base;
use Retheme\Helper;

class Homebuilder extends Customizer_Base {

    public function __construct() {
        $this->set_panel();
        $this->set_section();

        $this->add_layout();
        $this->add_slider();
        $this->add_product_archive();
        $this->add_product_loop();
        $this->add_blog_loop();

        if (rt_is_premium()) {
            $this->add_welcome_area();
            $this->add_product_category();
            $this->add_banner();
            $this->add_image();
            $this->add_image_content();
            $this->add_text_content();
        }
    }

    public function set_panel() {
        $this->add_panel('homebuilder_panel', [
            'title' => __('Front Page Builder', RT_THEME_DOMAIN),
            'priority' => 0,
        ]);
    }

    public function set_section() {
        $this->add_section('homebuilder_panel', [
            'homepage_layout' => [__('Layout', RT_THEME_DOMAIN)],
            'homepage_welcome' => [__('Welcome Area', RT_THEME_DOMAIN)],
            'homepage_slider' => [__('Images Slider', RT_THEME_DOMAIN)],
            'homepage_product_archive' => [__('Lastest Products', RT_THEME_DOMAIN)],
            'homepage_product_1' => [__('Product Catalog 1', RT_THEME_DOMAIN)],
            'homepage_product_2' => [__('Product Catalog 2', RT_THEME_DOMAIN)],
            'homepage_product_3' => [__('Product Catalog 3', RT_THEME_DOMAIN)],
            'homepage_product_cat' => [__('Product Categories', RT_THEME_DOMAIN)],
            'homepage_blog_1' => [__('Blog/News', RT_THEME_DOMAIN)],
            'homepage_infobox' => [__('Info Box', RT_THEME_DOMAIN)],
            'homepage_banner' => [__('Banner', RT_THEME_DOMAIN)],
            'homepage_image' => [__('Image', RT_THEME_DOMAIN)],
            'homepage_image_content' => [__('Image Content', RT_THEME_DOMAIN)],
            'homepage_text_content' => [__('Text Content', RT_THEME_DOMAIN)],
        ]);
    }

    public function add_layout() {
        $section = 'homepage_layout_section';

        if (rt_is_premium()) {
            $chooses = [
                'slider' => __('Images Slider', RT_THEME_DOMAIN),
                'welcome-area' => __('Welcome Area', RT_THEME_DOMAIN),
                'product-archive' => __('Lastest Products', RT_THEME_DOMAIN),
                'product-1' => __('Product Catalog 1', RT_THEME_DOMAIN),
                'product-2' => __('Product Catalog 2', RT_THEME_DOMAIN),
                'product-3' => __('Product Catalog 3', RT_THEME_DOMAIN),
                'product-category' => __('Product Categories', RT_THEME_DOMAIN),
                'blog-1' => __('Blog/News', RT_THEME_DOMAIN),
                'banner' => __('Banner', RT_THEME_DOMAIN),
                'image' => __('Image', RT_THEME_DOMAIN),
                'image-content' => __('Image Content', RT_THEME_DOMAIN),
                'text-content' => __('Text Content', RT_THEME_DOMAIN),
            ];
        } else {
            $chooses = [
                'slider' => __('Images Slider', RT_THEME_DOMAIN),
                'product-archive' => __('Product Archives', RT_THEME_DOMAIN),
                'product-1' => __('Product Catalog 1', RT_THEME_DOMAIN),
            ];
        }

        $this->add_field([
            'type' => 'sortable',
            'settings' => 'homebuilder_layout',
            'label' => __('Sections'),
            'section' => $section,
            'description' => __('Select (and re-order) front page sections that you want to display', RT_THEME_DOMAIN),
            'default' => [
                'product-1',
            ],
            'choices' => $chooses,
            'partial_refresh' => [
                'homebuilder_layout' => [
                    'selector' => '#homebuilder_layout_wrapper',
                    'render_callback' => function () {
                        rt_get_template_part("homepage/homepage-content");
                    },
                ],
            ],
        ]);

        $this->add_header([
            'label' => __('Homepage Layout', RT_THEME_DOMAIN),
            'settings' => 'homebuilder_content_layout',
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'radio-image',
            'settings' => 'homebuilder_content_layout',
            'label' => __('Layout', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => 'normal',
            'choices' => [
                'normal' => get_template_directory_uri() . '/core/customizer/assets/img/layout-normal.png',
                'compact' => get_template_directory_uri() . '/core/customizer/assets/img/layout-compact.png',
            ],
        ]);
    }

    public function get_homepage_content() {
        return [
            'homebuilder_layout' => [
                'selector' => '#homebuilder_layout_wrapper',
                'render_callback' => function () {
                    rt_get_template_part("homepage/homepage-content");
                },
            ],
        ];
    }

    public function add_text_content() {
        $section = 'homepage_text_content_section';

        $this->add_field([
            'type' => 'editor',
            'settings' => "homebuilder_text_content_text",
            'label' => __('Content', RT_THEME_DOMAIN),
            'tooltip' => __('Use the rich text editor to add in text into the section', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => "homebuilder_text_content_text_background_type",
            'section' => $section,
            'label' => __('Background', RT_THEME_DOMAIN),
            'default' => 'background-primary',
            'choices' => [
                'background-primary' => 'Primary',
                'background-secondary' => 'Secondary',
            ],
        ]);

        $this->add_field_responsive([
            'type' => 'dimensions',
            'settings' => "homebuilder_text_content_background_spacing",
            'label' => __('Spacing', RT_THEME_DOMAIN),
            'description' => __('Use CSS Unit px or %', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'top' => '0',
                'bottom' => '30px',
            ],
            'output' => [
                [
                    'element' => "#homepage-text-content",
                    'property' => 'padding',
                ],
            ],

            'transport' => 'auto',
        ]);
    }

    public function add_image() {
        $section = 'homepage_image_section';

        $this->add_field([
            'type' => 'image',
            'settings' => 'homebuilder_image',
            'label' => __('Image', RT_THEME_DOMAIN),
            'description' => __('Upload an image to be used for the section. For best results, the image should be at least 1200px wide and it looks best if the image is taller than the overall text you will be adding.', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => '',
            'choices' => [
                'save_as' => 'id',
            ],
        ]);

        $this->add_field([
            'label' => __('Expand full width', RT_THEME_DOMAIN),
            'type' => 'toggle',
            'section' => $section,
            'settings' => "homebuilder_image_full_width",
            'default' => false,
        ]);

        $this->add_field([
            'type' => 'link',
            'settings' => 'homebuilder_image_link_url',
            'label' => __('Link Url', RT_THEME_DOMAIN),
            'default' => '#',
            'section' => $section,
        ]);

        $this->add_field_responsive([
            'type' => 'dimensions',
            'settings' => 'homebuilder_image_padding',
            'label' => __('Spacing', RT_THEME_DOMAIN),
            'description' => __('Use CSS Unit px or %', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'left' => '0px',
                'top' => '0px',
                'right' => '0px',
                'bottom' => '0px',
            ],
            'choices' => [
                'labels' => [
                    'left' => __('Left', RT_THEME_DOMAIN),
                    'top' => __('Top', RT_THEME_DOMAIN),
                    'right' => __('Right', RT_THEME_DOMAIN),
                    'bottom' => __('Bottom', RT_THEME_DOMAIN),
                ],
            ],
            'output' => [
                [
                    'element' => '#homepage-image',
                    'property' => 'padding',
                ],
            ],
            'transport' => 'auto',
        ]);
    }

    public function add_image_content() {
        $section = 'homepage_image_content_section';

        $this->add_field([
            'type' => 'image',
            'settings' => 'homebuilder_image_content_item',
            'label' => __('Image', RT_THEME_DOMAIN),
            'tooltip' => __('Upload an image to be used for the section. For best results, the image should be at least 600px wide and it looks best if the image is taller than the overall text you will be adding.', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => '',
            'choices' => [
                'save_as' => 'id',
            ],
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_image_content_title",
            'label' => __('Title', RT_THEME_DOMAIN),
            'default' => __('Title Image Content', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'editor',
            'settings' => "homebuilder_image_content_content",
            'label' => __('Content', RT_THEME_DOMAIN),
            'default' => __('Add rich text to the section. Ideally the text should be short and to the point in order to prevent if from being taller than the image.', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_image_content_link_text",
            'label' => __('Link Text', RT_THEME_DOMAIN),
            'default' => __('Read More', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'link',
            'settings' => 'homebuilder_image_content_link_url',
            'label' => __('Link Url', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => get_site_url(),
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'homebuilder_image_content_link_style',
            'section' => $section,
            'label' => __('Button Style', 'admin_domain'),
            'default' => 'button-link',
            'choices' => array(
                'button-link' => 'Link',
                'button-primary' => 'Button Primary',
                'button-action' => 'Button Action',
            ),
        ]);

        $this->add_field([
            'type' => 'radio-buttonset',
            'settings' => "homebuilder_image_content_text_align",
            'label' => __('Text align', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => 'left',
            'choices' => [
                'left' => '<i class="fas fa-align-left"></i>',
                'center' => '<i class="fas fa-align-center"></i>',
                'right' => '<i class="fas fa-align-right"></i>',
            ],
            'output' => [
                [
                    'element' => '#homepage-image-content',
                    'property' => 'text-align',
                ],
            ],
            'transport' => 'auto',
        ]);

        // section
        $this->add_header([
            'label' => 'Section',
            'settings' => "homebuilder_image_content",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => "homebuilder_image_content_background_type",
            'section' => $section,
            'label' => __('Background', RT_THEME_DOMAIN),
            'default' => 'background-primary',
            'choices' => [
                'background-primary' => 'Primary',
                'background-secondary' => 'Secondary',
            ],
        ]);

        $this->add_field_responsive([
            'type' => 'dimensions',
            'settings' => "homebuilder_image_content_background_spacing",
            'label' => __('Spacing', RT_THEME_DOMAIN),
            'description' => __('Use CSS Unit px or %', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'top' => '0',
                'bottom' => '30px',
            ],
            'output' => [
                [
                    'element' => '#homepage-image-content',
                    'property' => 'padding',
                ],
            ],
            'transport' => 'auto',
        ]);
    }

    public function add_slider() {
        $section = 'homepage_slider_section';

        $this->add_header([
            'label' => __('Options', RT_THEME_DOMAIN),
            'settings' => "homebuilder_slider_layout",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'repeater',
            'label' => __('Image Slides', RT_THEME_DOMAIN),
            'tooltip' => __('With each image slide you have the option to upload an image and set the links.  For best results, all of your slides should use images that are identical in size and ratio. One recommended size that works well for most shops is 1500 x 600px.', RT_THEME_DOMAIN),
            'section' => $section,
            'row_label' => [
                'type' => 'field',
                'value' => __('Slider Item', RT_THEME_DOMAIN),
                'field' => 'title',
            ],
            'button_label' => __("Add New Slider", RT_THEME_DOMAIN),
            'settings' => 'homebuilder_slider',
            'fields' => [
                'image' => [
                    'type' => 'image',
                    'label' => __('Image', RT_THEME_DOMAIN),
                    'choices' => [
                        'save_as' => 'id',
                    ],
                ],
                'link_url' => [
                    'type' => 'link',
                    'label' => __('Link URL', RT_THEME_DOMAIN),
                ],
            ],

        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'homebuilder_slider_image_size',
            'label' => __('Image Size', RT_THEME_DOMAIN),
            'section' => $section,
            'multiple' => 1,
            'default' => 'full',
            'choices' => Helper::get_image_size(),
        ]);

        $this->add_field([
            'label' => __('Expand full width', RT_THEME_DOMAIN),
            'type' => 'toggle',
            'section' => $section,
            'settings' => "homebuilder_slider_full_width",
            'default' => true,
        ]);

        $this->add_field([
            'type' => 'toggle',
            'section' => $section,
            'settings' => "homebuilder_slider_loop",
            'label' => __('Infinity Loop', RT_THEME_DOMAIN),
        ]);

        $this->add_field([
            'type' => 'toggle',
            'section' => $section,
            'settings' => "homebuilder_slider_autoplay",
            'label' => __('Auto Play', RT_THEME_DOMAIN),
        ]);

        $this->add_field([
            'type' => 'toggle',
            'section' => $section,
            'settings' => "homebuilder_slider_nav",
            'label' => __('Navigation', RT_THEME_DOMAIN),
            'default' => true,
        ]);

        $this->add_header([
            'label' => 'Section',
            'settings' => "homebuilder_slider_section",
            'section' => $section,
        ]);

        $this->add_field_responsive([
            'type' => 'dimensions',
            'settings' => "homebuilder_slider_background_spacing",
            'label' => __('Spacing', RT_THEME_DOMAIN),
            'description' => __('Use CSS Unit px or %', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'top' => '30px',
                'bottom' => '30px',
            ],
            'output' => [
                [
                    'element' => "#homepage-slider",
                    'property' => 'padding',
                ],
            ],
            'transport' => 'auto',
        ]);
    }

    public function add_banner() {
        $section = 'homepage_banner_section';

        $this->add_header([
            'label' => __('Options', RT_THEME_DOMAIN),
            'settings' => "homebuilder_banner",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'repeater',
            'label' => __('Content', RT_THEME_DOMAIN),
            'section' => $section,
            'row_label' => [
                'type' => 'field',
                'value' => __('Banner Item', RT_THEME_DOMAIN),
                'field' => 'title',
            ],
            'button_label' => __('Add New Banner', RT_THEME_DOMAIN),
            'settings' => 'homebuilder_banner',
            'fields' => [
                'image' => [
                    'type' => 'image',
                    'label' => __('Image', RT_THEME_DOMAIN),
                    'choices' => [
                        'save_as' => 'id',
                    ],
                ],
                'link' => [
                    'type' => 'link',
                    'label' => __('Link Url', RT_THEME_DOMAIN),
                ],
            ],

        ]);

        $this->add_field([
            'type' => 'toggle',
            'section' => $section,
            'settings' => "homebuilder_banner_carousel",
            'label' => __('Carousel', RT_THEME_DOMAIN),
        ]);

        $this->add_field_responsive([
            'type' => 'slider',
            'section' => $section,
            'settings' => "homebuilder_banner_column",
            'label' => __('Column', RT_THEME_DOMAIN),
            'description' => __('Number of Column Per Row', RT_THEME_DOMAIN),
            'default' => 3,
            'default_tablet' => 2,
            'default_mobile' => 2,
            'choices' => [
                'min' => 1,
                'max' => 6,
            ],
            'active_callback' => [
                [
                    'setting' => "homebuilder_banner_carousel",
                    'operator' => '!==',
                    'value' => true,
                ],
            ],

        ]);

        $this->add_field_responsive([
            'type' => 'slider',
            'settings' => "homebuilder_banner_slider_show",
            'section' => $section,
            'label' => __('Slides Per View', RT_THEME_DOMAIN),
            'default' => 3,
            'default_tablet' => 2,
            'default_mobile' => 2,
            'choices' => [
                'min' => 1,
                'max' => 6,
            ],
            'active_callback' => [
                [
                    'setting' => "homebuilder_banner_carousel",
                    'operator' => '==',
                    'value' => true,
                ],
            ],

        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'homebuilder_banner_image_size',
            'label' => __('Image Size', RT_THEME_DOMAIN),
            'section' => $section,
            'multiple' => 1,
            'default' => 'featured_medium',
            'choices' => Helper::get_image_size(),
        ]);

        // section
        $this->add_header([
            'label' => 'Section',
            'settings' => "homebuilder_banner_section",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_banner_title",
            'label' => __('Title', RT_THEME_DOMAIN),
            'default' => __('Banner Title', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'textarea',
            'settings' => "homebuilder_banner_desc",
            'label' => __('Description', RT_THEME_DOMAIN),
            'default' => __('Banner Description', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => "homebuilder_banner_background_type",
            'section' => $section,
            'label' => __('Background', RT_THEME_DOMAIN),
            'default' => 'background-primary',
            'choices' => [
                'background-primary' => 'Primary',
                'background-secondary' => 'Secondary',
            ],
        ]);

        $this->add_field_responsive([
            'type' => 'dimensions',
            'settings' => "homebuilder_banner_background_spacing",
            'label' => __('Spacing', RT_THEME_DOMAIN),
            'description' => __('Use CSS Unit px or %', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'top' => '0',
                'bottom' => '30px',
            ],
            'output' => [
                [
                    'element' => "#homepage-banner",
                    'property' => 'padding',
                ],
            ],

            'transport' => 'auto',
        ]);
    }

    public function add_infobox() {
        $section = 'homepage_infobox_section';

        $this->add_header([
            'label' => __('Items', RT_THEME_DOMAIN),
            'settings' => "homebuilder_infobox_item",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'repeater',
            'label' => __('Info Box', RT_THEME_DOMAIN),
            'section' => $section,
            'row_label' => [
                'type' => 'field',
                'value' => __('Info Item', RT_THEME_DOMAIN),
                'field' => 'title',
            ],
            'button_label' => __('Add New Info Box', RT_THEME_DOMAIN),
            'settings' => 'homebuilder_infobox',
            'fields' => [
                'image' => [
                    'type' => 'image',
                    'label' => __('Image', RT_THEME_DOMAIN),
                    'choices' => [
                        'save_as' => 'id',
                    ],
                ],
                'title' => [
                    'type' => 'text',
                    'label' => __('Title', RT_THEME_DOMAIN),
                ],
                'content' => [
                    'type' => 'textarea',
                    'label' => __('Content', RT_THEME_DOMAIN),
                ],
                'link_text' => [
                    'type' => 'text',
                    'label' => __('Link Text', RT_THEME_DOMAIN),
                ],
                'link_url' => [
                    'type' => 'link',
                    'label' => __('Link Url', RT_THEME_DOMAIN),
                ],
            ],
        ]);

        $this->add_header([
            'label' => __('Options', RT_THEME_DOMAIN),
            'settings' => "homebuilder_infobox",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'toggle',
            'section' => $section,
            'settings' => "homebuilder_infobox_carousel",
            'label' => __('Carousel', RT_THEME_DOMAIN),
        ]);

        $this->add_field_responsive([
            'type' => 'slider',
            'section' => $section,
            'settings' => "homebuilder_infobox_column",
            'label' => __('Column', RT_THEME_DOMAIN),
            'description' => __('Number of Column Per Row', RT_THEME_DOMAIN),
            'default' => 3,
            'default_tablet' => 2,
            'default_mobile' => 2,
            'choices' => [
                'min' => 1,
                'max' => 6,
            ],
            'active_callback' => [
                [
                    'setting' => "homebuilder_infobox_carousel",
                    'operator' => '!==',
                    'value' => true,
                ],
            ],

        ]);

        $this->add_field_responsive([
            'type' => 'slider',
            'settings' => "homebuilder_infobox_slider_show",
            'section' => $section,
            'label' => __('Slides Per View', RT_THEME_DOMAIN),
            'default' => 3,
            'default_tablet' => 2,
            'default_mobile' => 2,
            'choices' => [
                'min' => 1,
                'max' => 6,
            ],
            'active_callback' => [
                [
                    'setting' => "homebuilder_infobox_carousel",
                    'operator' => '==',
                    'value' => true,
                ],
            ],

        ]);

        // section
        $this->add_header([
            'label' => 'Section',
            'settings' => "homebuilder_infobox_section",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_infobox_title",
            'label' => __('Title', RT_THEME_DOMAIN),
            'default' => __('Info Box Title', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'textarea',
            'settings' => "homebuilder_infobox_desc",
            'label' => __('Description', RT_THEME_DOMAIN),
            'default' => __('Info Box Description', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => "homebuilder_infobox_background_type",
            'section' => $section,
            'label' => __('Background', RT_THEME_DOMAIN),
            'default' => 'background-primary',
            'choices' => [
                'background-primary' => 'Primary',
                'background-secondary' => 'Secondary',
            ],
        ]);

        $this->add_field_responsive([
            'type' => 'dimensions',
            'settings' => "homebuilder_infobox_background_spacing",
            'label' => __('Spacing', RT_THEME_DOMAIN),
            'description' => __('Use CSS Unit px or %', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'top' => '0',
                'bottom' => '30px',
            ],
            'output' => [
                [
                    'element' => "#homepage-infobox",
                    'property' => 'padding',
                ],
            ],

            'transport' => 'auto',
        ]);
    }

    public function add_product_archive() {
        $section = "homepage_product_archive_section";

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_product_archive_title",
            'label' => __('Title', RT_THEME_DOMAIN),
            'default' => __('Shop', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'textarea',
            'settings' => "homebuilder_product_archive_desc",
            'label' => __('Description', RT_THEME_DOMAIN),
            'default' => __('Lastest Product', RT_THEME_DOMAIN),
            'section' => $section,
        ]);
    }

    public function add_product_loop() {

        // before product loop
        $total = (rt_is_premium()) ? 3 : 1;

        for ($index = 1; $index <= $total; $index++) {

            $section = "homepage_product_{$index}_section";
            $setting = "homebuilder_product_{$index}";

            $this->add_header([
                'label' => __('Options', RT_THEME_DOMAIN),
                'settings' => "homebuilder_product_{$index}",
                'section' => $section,
            ]);

            $this->add_field([
                'type' => 'toggle',
                'section' => $section,
                'settings' => "homebuilder_product_{$index}_carousel",
                'label' => __('Carousel', RT_THEME_DOMAIN),
            ]);

            $this->add_field_responsive([
                'type' => 'slider',
                'section' => $section,
                'settings' => "homebuilder_product_{$index}_column",
                'label' => __('Column', RT_THEME_DOMAIN),
                'description' => __('Number of Column Per Row', RT_THEME_DOMAIN),
                'default' => 3,
                'default_tablet' => 2,
                'default_mobile' => 2,
                'choices' => [
                    'min' => 1,
                    'max' => 6,
                ],
                'active_callback' => [
                    [
                        'setting' => "homebuilder_product_{$index}_carousel",
                        'operator' => '!==',
                        'value' => true,
                    ],
                ],
            ]);

            $this->add_field_responsive([
                'type' => 'slider',
                'settings' => "homebuilder_product_{$index}_slider_show",
                'section' => $section,
                'label' => __('Slides Per View', RT_THEME_DOMAIN),
                'default' => 3,
                'default_tablet' => 2,
                'default_mobile' => 2,
                'choices' => [
                    'min' => 1,
                    'max' => 6,
                ],
                'active_callback' => [
                    [
                        'setting' => "{$setting}_carousel",
                        'operator' => '==',
                        'value' => true,
                    ],
                ],

            ]);

            $this->add_field([
                'type' => 'toggle',
                'label' => __('Link Action', RT_THEME_DOMAIN),
                'section' => $section,
                'settings' => "homebuilder_product_{$index}_slider_link",
                'active_callback' => [
                    [
                        'setting' => "homebuilder_product_{$index}_carousel",
                        'operator' => '==',
                        'value' => true,
                    ],
                ],

            ]);

            $this->add_field([
                'type' => 'select',
                'section' => $section,
                'settings' => "homebuilder_product_{$index}_pagination",
                'label' => __('Pagination Style', RT_THEME_DOMAIN),
                'default' => 'none',
                'multiple' => 1,
                'choices' => [
                    'none' => __('None', RT_THEME_DOMAIN),
                    'loadmore' => __('Load More', RT_THEME_DOMAIN),
                    'link' => __('Link Url', RT_THEME_DOMAIN),
                ],
                'active_callback' => [
                    [
                        'setting' => "homebuilder_product_{$index}_carousel",
                        'operator' => '!=',
                        'value' => true,
                    ],
                ],

            ]);

            $this->add_field([
                'type' => 'text',
                'settings' => "homebuilder_product_{$index}_pagination_link_text",
                'label' => __('Link Text', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => __('View More', RT_THEME_DOMAIN),
                'active_callback' => [
                    [
                        [
                            'setting' => "homebuilder_product_{$index}_slider_link",
                            'operator' => '==',
                            'value' => true,
                        ],
                        [
                            'setting' => "homebuilder_product_{$index}_pagination",
                            'operator' => '==',
                            'value' => 'link',
                        ],
                    ],
                ],
            ]);

            $this->add_field([
                'type' => 'link',
                'settings' => "homebuilder_product_{$index}_pagination_link_url",
                'label' => __('Link Url', RT_THEME_DOMAIN),
                'section' => $section,
                'active_callback' => [
                    [
                        [
                            'setting' => "homebuilder_product_{$index}_slider_link",
                            'operator' => '==',
                            'value' => true,
                        ],
                        [
                            'setting' => "homebuilder_product_{$index}_pagination",
                            'operator' => '==',
                            'value' => 'link',
                        ],
                    ],
                ],
            ]);

            $this->add_header([
                'label' => __('Query', RT_THEME_DOMAIN),
                'settings' => "homebuilder_product_{$index}_query",
                'section' => $section,
            ]);

            $this->add_field([
                'type' => 'select',
                'section' => $section,
                'settings' => "homebuilder_product_{$index}_query_by",
                'label' => __('Query Products by', RT_THEME_DOMAIN),
                'default' => 'lastest',
                'multiple' => 1,
                'choices' => [
                    'lastest' => __('Lastest Products', RT_THEME_DOMAIN),
                    'featured' => __('Featured Products', RT_THEME_DOMAIN),
                    'category' => __('Categories', RT_THEME_DOMAIN),
                    'manually' => __('Hand Picks', RT_THEME_DOMAIN),
                ],
            ]);

            $this->add_field([
                'type' => 'select',
                'section' => $section,
                'settings' => "homebuilder_product_{$index}_category",
                'label' => __('Category', RT_THEME_DOMAIN),
                'multiple' => 99,
                'choices' => Helper::get_terms('product_cat'),
                'active_callback' => [
                    [
                        'setting' => "homebuilder_product_{$index}_query_by",
                        'operator' => '==',
                        'value' => 'category',
                    ],
                ],
            ]);

            $this->add_field([
                'type' => 'select',
                'section' => $section,
                'settings' => "homebuilder_product_{$index}_id",
                'label' => __('Select Product', RT_THEME_DOMAIN),
                'multiple' => 99,
                'choices' => \Kirki_Helper::get_posts([
                    'posts_per_page' => 10,
                    'post_type'      => 'product'
                ]),
                'active_callback' => [
                    [
                        'setting' => "homebuilder_product_{$index}_query_by",
                        'operator' => '==',
                        'value' => 'manually',
                    ],
                ],
            ]);

            $this->add_field([
                'type' => 'select',
                'section' => $section,
                'settings' => "homebuilder_product_{$index}_orderby",
                'label' => __('Order By', RT_THEME_DOMAIN),
                'default' => 'date',
                'multiple' => 1,
                'choices' => [
                    'ID' => 'Post Id',
                    'author' => 'Post Author',
                    'title' => 'Title',
                    'date' => 'Date',
                    'modified' => 'Last Modified Date',
                    'total_sales' => __('Most Selling'),
                    'wp_post_views_count' => __('Most Viewer'),
                    'comment_count' => __('Most Review'),
                ],

            ]);

            $this->add_field([
                'type' => 'number',
                'section' => $section,
                'settings' => "homebuilder_product_{$index}_posts_per_page",
                'label' => __('Posts Per Page', RT_THEME_DOMAIN),
                'default' => 9,
            ]);

            // section
            $this->add_header([
                'label' => 'Section',
                'settings' => "homebuilder_product_{$index}_section",
                'section' => $section,
            ]);

            $this->add_field([
                'type' => 'text',
                'settings' => "homebuilder_product_{$index}_title",
                'label' => __('Title', RT_THEME_DOMAIN),
                'default' => __('Product Title', RT_THEME_DOMAIN),
                'section' => $section,
            ]);

            $this->add_field([
                'type' => 'textarea',
                'settings' => "homebuilder_product_{$index}_desc",
                'label' => __('Description', RT_THEME_DOMAIN),
                'default' => __('Product Description', RT_THEME_DOMAIN),
                'section' => $section,
            ]);

            $this->add_field([
                'type' => 'select',
                'settings' => "homebuilder_product_{$index}_background_type",
                'section' => $section,
                'label' => __('Background', RT_THEME_DOMAIN),
                'default' => 'background-primary',
                'choices' => [
                    'background-primary' => 'Primary',
                    'background-secondary' => 'Secondary',
                ],
            ]);

            $this->add_field_responsive([
                'type' => 'dimensions',
                'settings' => "homebuilder_product_{$index}_background_spacing",
                'label' => __('Spacing', RT_THEME_DOMAIN),
                'description' => __('Use CSS Unit px or %', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => [
                    'top' => '0',
                    'bottom' => '30px',
                ],
                'output' => [
                    [
                        'element' => "#homepage-product-{$index}",
                        'property' => 'padding',
                    ],
                ],
                'transport' => 'auto',
            ]);
        }
    }

    public function add_product_category() {
        $section = 'homepage_product_cat_section';

        $this->add_header([
            'label' => __('General', RT_THEME_DOMAIN),
            'settings' => "homebuilder_product_category",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'homebuilder_product_category_style',
            'label' => __('Style', RT_THEME_DOMAIN),
            'default' => 'style-1',
            'section' => $section,
            'choices' => [
                'style-1' => __('Style 1'),
                'style-2' => __('Style 2'),
            ],

        ]);

        $this->add_field([
            'type' => 'toggle',
            'settings' => 'homebuilder_product_category_hide_empty',
            'label' => __('Hide Empty Category', RT_THEME_DOMAIN),
            'section' => $section,

        ]);

        $this->add_field_responsive([
            'type' => 'slider',
            'settings' => "homebuilder_product_category_slider_show",
            'section' => $section,
            'label' => __('Slides Per View', RT_THEME_DOMAIN),
            'default' => 3,
            'default_tablet' => 2,
            'default_mobile' => 2,
            'choices' => [
                'min' => 1,
                'max' => 6,
            ],
            'active_callback' => [
                [
                    'setting' => "homebuilder_product_category_style",
                    'operator' => '==',
                    'value' => 'style-1',
                ],
            ],

        ]);


        // section
        $this->add_header([
            'label' => 'Section',
            'settings' => "homebuilder_product_category_section",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_product_category_title",
            'label' => __('Title', RT_THEME_DOMAIN),
            'default' => __('Categories Title', RT_THEME_DOMAIN),
            'section' => $section,

        ]);

        $this->add_field([
            'type' => 'textarea',
            'settings' => "homebuilder_product_category_desc",
            'label' => __('Description', RT_THEME_DOMAIN),
            'default' => __('Categories Description', RT_THEME_DOMAIN),
            'section' => $section,

        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => "homebuilder_product_category_background_type",
            'section' => $section,
            'label' => __('Background', RT_THEME_DOMAIN),
            'default' => 'background-primary',
            'choices' => [
                'background-primary' => 'Primary',
                'background-secondary' => 'Secondary',
            ],
        ]);

        $this->add_field_responsive([
            'type' => 'dimensions',
            'settings' => "homebuilder_product_category_background_spacing",
            'label' => __('Spacing', RT_THEME_DOMAIN),
            'description' => __('Use CSS Unit px or %', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'top' => '0',
                'bottom' => '30px',
            ],
            'output' => [
                [
                    'element' => "#homepage-product-category",
                    'property' => 'padding',
                ],
            ],
            'transport' => 'auto',
        ]);
    }

    public function add_blog_loop() {

        $section = "homepage_blog_1_section";

        $this->add_header([
            'label' => __('Options', RT_THEME_DOMAIN),
            'settings' => "homebuilder_blog_1",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'toggle',
            'section' => $section,
            'settings' => "homebuilder_blog_1_carousel",
            'label' => __('Carousel', RT_THEME_DOMAIN),
        ]);

        $this->add_field_responsive([
            'type' => 'slider',
            'section' => $section,
            'settings' => "homebuilder_blog_1_column",
            'label' => __('Column', RT_THEME_DOMAIN),
            'description' => __('Number of Column Per Row', RT_THEME_DOMAIN),
            'default' => 3,
            'default_tablet' => 2,
            'default_mobile' => 2,
            'choices' => [
                'min' => 1,
                'max' => 6,
            ],
            'active_callback' => [
                [
                    'setting' => "homebuilder_blog_1_carousel",
                    'operator' => '!==',
                    'value' => true,
                ],
            ],

        ]);

        $this->add_field_responsive([
            'type' => 'slider',
            'settings' => "homebuilder_blog_1_slider_show",
            'section' => $section,
            'label' => __('Slides Per View', RT_THEME_DOMAIN),
            'default' => 3,
            'default_tablet' => 2,
            'default_mobile' => 2,
            'choices' => [
                'min' => 1,
                'max' => 6,
            ],
            'active_callback' => [
                [
                    'setting' => "homebuilder_blog_1_carousel",
                    'operator' => '==',
                    'value' => true,
                ],
            ],

        ]);

        $this->add_field([
            'type' => 'toggle',
            'label' => __('Link Action', RT_THEME_DOMAIN),
            'section' => $section,
            'settings' => "homebuilder_blog_1_slider_link",
            'active_callback' => [
                [
                    'setting' => "homebuilder_blog_1_carousel",
                    'operator' => '==',
                    'value' => true,
                ],
            ],

        ]);

        $this->add_field([
            'type' => 'select',
            'section' => $section,
            'settings' => "homebuilder_blog_1_pagination",
            'label' => __('Pagination Style', RT_THEME_DOMAIN),
            'default' => 'none',
            'multiple' => 1,
            'choices' => [
                'none' => __('None', RT_THEME_DOMAIN),
                'loadmore' => __('Load More', RT_THEME_DOMAIN),
                'link' => __('Link Url', RT_THEME_DOMAIN),
            ],
            'active_callback' => [
                [
                    'setting' => "homebuilder_blog_1_carousel",
                    'operator' => '!==',
                    'value' => true,
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_blog_1_pagination_link_text",
            'label' => __('Link Text', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => __('View More', RT_THEME_DOMAIN),
            'active_callback' => [
                [
                    [
                        'setting' => "homebuilder_blog_1_slider_link",
                        'operator' => '==',
                        'value' => true,
                    ],
                    [
                        'setting' => "homebuilder_blog_1_pagination",
                        'operator' => '==',
                        'value' => 'link',
                    ],
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'link',
            'settings' => "homebuilder_blog_1_pagination_link_url",
            'label' => __('Link Url', RT_THEME_DOMAIN),
            'section' => $section,
            'active_callback' => [
                [
                    [
                        'setting' => "homebuilder_blog_1_slider_link",
                        'operator' => '==',
                        'value' => true,
                    ],
                    [
                        'setting' => "homebuilder_blog_1_pagination",
                        'operator' => '==',
                        'value' => 'link',
                    ],
                ],
            ],
        ]);

        $this->add_header([
            'label' => __('Query', RT_THEME_DOMAIN),
            'settings' => "homebuilder_blog_1_query",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'select',
            'section' => $section,
            'settings' => "homebuilder_blog_1_query_by",
            'label' => __('Query posts by', RT_THEME_DOMAIN),
            'default' => 'lastest',
            'multiple' => 1,
            'choices' => [
                'lastest' => __('Lastest Posts', RT_THEME_DOMAIN),
                'category' => __('Categories', RT_THEME_DOMAIN),
                'manually' => __('Hand Picks', RT_THEME_DOMAIN),
            ],

        ]);

        $this->add_field([
            'type' => 'select',
            'section' => $section,
            'settings' => "homebuilder_blog_1_category",
            'label' => __('Category', RT_THEME_DOMAIN),
            'multiple' => 99,
            'choices' => Helper::get_terms('category'),
            'active_callback' => [
                [
                    'setting' => "homebuilder_blog_1_query_by",
                    'operator' => '==',
                    'value' => 'category',
                ],
            ],

        ]);

        $this->add_field([
            'type' => 'select',
            'section' => $section,
            'settings' => "homebuilder_blog_1_id",
            'label' => __('Select Post'),
            'multiple' => 99,
            'choices' => \Kirki_Helper::get_posts([
                'posts_per_page' => 10,
                'post_type'      => 'post'
            ]),

            'active_callback' => [
                [
                    'setting' => "homebuilder_blog_1_query_by",
                    'operator' => '==',
                    'value' => 'manually',
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'select',
            'section' => $section,
            'settings' => "homebuilder_blog_1_orderby",
            'label' => __('Order By', RT_THEME_DOMAIN),
            'default' => 'date',
            'multiple' => 1,
            'choices' => [
                'ID' => __('Post Id', RT_THEME_DOMAIN),
                'author' => __('Post Author', RT_THEME_DOMAIN),
                'title' => __('Title', RT_THEME_DOMAIN),
                'date' => __('Date', RT_THEME_DOMAIN),
                'modified' => __('Last Modified Date', RT_THEME_DOMAIN),
                'comment_count' => __('Most Comment', RT_THEME_DOMAIN),
            ],

        ]);

        $this->add_field([
            'type' => 'number',
            'section' => $section,
            'settings' => "homebuilder_blog_1_posts_per_page",
            'label' => __('Posts Per Page', RT_THEME_DOMAIN),
            'default' => 9,
        ]);

        // section
        $this->add_header([
            'label' => 'Section',
            'settings' => "homebuilder_blog_1_section",
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_blog_1_title",
            'label' => __('Title', RT_THEME_DOMAIN),
            'default' => __('Post Title', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'textarea',
            'settings' => "homebuilder_blog_1_desc",
            'label' => __('Description', RT_THEME_DOMAIN),
            'default' => __('Post Description', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => "homebuilder_blog_1_background_type",
            'section' => $section,
            'label' => __('Background', RT_THEME_DOMAIN),
            'default' => 'background-primary',
            'choices' => [
                'background-primary' => 'Primary',
                'background-secondary' => 'Secondary',
            ],
        ]);

        $this->add_field_responsive([
            'type' => 'dimensions',
            'settings' => "homebuilder_blog_1_background_spacing",
            'label' => __('Spacing', RT_THEME_DOMAIN),
            'description' => __('Use CSS Unit px or %', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'top' => '0',
                'bottom' => '30px',
            ],
            'output' => [
                [
                    'element' => "#homepage-blog-1",
                    'property' => 'padding',
                ],
            ],

            'transport' => 'auto',
        ]);
    }

    public function add_welcome_area() {
        $section = "homepage_welcome_section";

        $this->add_field([
            'type' => 'radio-image',
            'settings' => 'homebuilder_welcome_style',
            'section' => $section,
            'label' => __('Style', 'admin_domain'),
            'default' => 'style-1',
            'choices' => [
                'style-1' => get_template_directory_uri() . '/core/customizer/assets/img/welcome-area-1.png',
                'style-2' => get_template_directory_uri() . '/core/customizer/assets/img/welcome-area-2.png',
                'style-3' => get_template_directory_uri() . '/core/customizer/assets/img/welcome-area-3.png',
            ],
        ]);

        $this->add_field([
            'type' => 'image',
            'settings' => 'homebuilder_welcome_image',
            'label' => __('Image', RT_THEME_DOMAIN),
            'section' => $section,
            'choices' => [
                'save_as' => 'id',
            ],
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_welcome_text_intro",
            'label' => __('Sub Title', RT_THEME_DOMAIN),
            'default' => __('Sub Title', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_welcome_title",
            'label' => __('Title', RT_THEME_DOMAIN),
            'default' => __('Title', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'textarea',
            'settings' => "homebuilder_welcome_content",
            'label' => __('Content', RT_THEME_DOMAIN),
            'default' => __('Text content', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => "homebuilder_welcome_link_label",
            'label' => __('Button label', RT_THEME_DOMAIN),
            'default' => __('Read More', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'link',
            'settings' => 'homebuilder_welcome_link_url',
            'label' => __('Button Url', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => '#',
        ]);


        $this->add_header([
            'label' => __('Advanced Styles', RT_THEME_DOMAIN),
            'settings' => 'homebuilder_welcome_style',
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'toggle',
            'settings' => 'homebuilder_welcome_background_overlay',
            'label' => __('Background Overlay', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => false,
        ]);

        $this->add_field([
            'type' => 'background',
            'settings'    => 'homebuilder_welcome_background',
            'label' => __('Background', RT_THEME_DOMAIN),
            'section' => $section,
            'default'     => [
                'background-color'      => rt_get_theme('global_background_scheme')['secondary'],
                'background-image'      => '',
                'background-repeat'     => 'no-repeat',
                'background-position'   => 'center center',
                'background-size'       => 'cover',
                'background-attachment' => 'scroll',
            ],
            'transport'   => 'auto',
            'output'      => [
                [
                    'element' => '.rt-welcome-area__background',
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'color',
            'settings' => 'homebuilder_welcome_sub_title_color',
            'label' => __('Sub Title Color', RT_THEME_DOMAIN),
            'default' => rt_get_theme('global_font_color')['tertiary'],
            'choices' => ['alpha' => true,],
            'section' => $section,
            'transport'   => 'auto',
            'output'      => [
                [
                    'element' => '.rt-welcome-area',
                    'property' => '--theme-font-color-tertiary',
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'color',
            'settings' => 'homebuilder_welcome_title_color',
            'label' => __('Title Color', RT_THEME_DOMAIN),
            'default' => rt_get_theme('global_font_color')['primary'],
            'choices' => ['alpha' => true,],
            'section' => $section,
            'transport'   => 'auto',
            'output'      => [
                [
                    'element' => '.rt-welcome-area__title',
                    'property' => '--theme-font-color-primary',
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'color',
            'settings' => 'homebuilder_welcome_body_color',
            'label' => __('Text Color', RT_THEME_DOMAIN),
            'default' => rt_get_theme('global_font_color')['secondary'],
            'choices' => ['alpha' => true,],
            'section' => $section,
            'transport'   => 'auto',
            'output'      => [
                [
                    'element' => '.rt-welcome-area__content',
                    'property' => '--theme-font-color-secondary',
                ],
            ],
        ]);


        $this->add_field_responsive([
            'type' => 'typography',
            'settings' => 'homebuilder_welcome_typography_title',
            'label' => __('Title Typography', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'font-family' => 'Inter',
                'variant' => '600',
                'font-size' => '30px',
                'line-height' => '1.2',
            ],
            'output' => [
                [
                    'element' => '.rt-welcome-area__title',
                ],
            ],
            'transport' => 'auto',
        ]);


        $this->add_field_responsive([
            'type' => 'typography',
            'settings' => 'homebuilder_welcome_typography_content',
            'label' => __('Content Typography', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'font-size' => '17px',
                'line-height' => '1.75',
            ],
            'output' => [
                [
                    'element' => '.rt-welcome-area__content',
                ],
            ],
            'transport' => 'auto',
        ]);


        // section
        $this->add_header([
            'label' => 'Section',
            'settings' => "homebuilder_welcome_section",
            'section' => $section,
        ]);

        $this->add_field_responsive([
            'type' => 'dimensions',
            'settings' => "homebuilder_welcome_background_spacing",
            'label' => __('Spacing', RT_THEME_DOMAIN),
            'description' => __('Use CSS Unit px or %', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'top' => '90px',
                'bottom' => '90px',
            ],
            'output' => [
                [
                    'element' => "#homepage-welcome-area",
                    'property' => 'padding',
                ],
            ],
            'transport' => 'auto',
        ]);
    }

    // end class
}

new Homebuilder;
