<?php
/**
 * @author : Reret
 */
namespace Retheme\Customizer;

use Retheme\Customizer_Base;

class Footer extends Customizer_Base
{

    public function __construct()
    {
        $this->set_panel();
        $this->set_section();
        $this->add_option_widget();
        $this->add_option_bottom();

    }

    public function set_panel()
    {
        $this->add_panel('footer_panel', [
            'title' => __('Footer', RT_THEME_DOMAIN),
        ]);
    }

    public function set_section()
    {
        $this->add_section('footer_panel', [
            'footer_widget' => [__('Widget Footer', RT_THEME_DOMAIN)],
            'footer_bottom' => [__('Bottom Footer', RT_THEME_DOMAIN)],
        ]);
    }

    public function add_option_widget()
    {

        $section = 'footer_widget_section';

        $this->add_field([
            'type' => 'toggle',
            'settings' => 'footer_widget',
            'label' => __('Enable Footer Widgets', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => false,
        ]);

        if (rt_is_premium()) {
            $this->add_field([
                'type' => 'radio-image',
                'section' => $section,
                'settings' => 'footer_widget_layout',
                'label' => __('Layout', RT_THEME_DOMAIN),
                'description' => sprintf( __( 'Visit the <a href="%s">Widgets panel</a> and add widget to display a element in a footer.', RT_THEME_DOMAIN), "javascript:wp.customize.panel( 'widgets' ).focus();" ),
                'default' => 'footer-1',
                'choices' => [
                    'footer-1' => get_template_directory_uri() . '/core/customizer/assets/img/footer-1.png',
                    'footer-2' => get_template_directory_uri() . '/core/customizer/assets/img/footer-2.png',
                    'footer-3' => get_template_directory_uri() . '/core/customizer/assets/img/footer-6.png',
                    'footer-4' => get_template_directory_uri() . '/core/customizer/assets/img/footer-7.png',
                    'footer-5' => get_template_directory_uri() . '/core/customizer/assets/img/footer-3.png',
                ],
            ]);

            $this->add_field_responsive([
                'type' => 'typography',
                'settings' => 'footer_widget_heading_typography',
                'label' => __('Heading Typography', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => [
                    'margin-bottom' => '',
                    'font-size' => '',
                    'line-height' => '',
                    'text-transform' => 'none',
                ],
                'output' => [
                    [
                        'element' => '.rt-widget--footer .rt-widget__title',
                        'suffix' => '!important',
                    ],
                ],
                'transport' => 'auto',
            ]);

            $this->add_field_color([
                'settings' => 'footer_widget_heading_color',
                'label' => __('Heading Color', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => rt_get_theme('global_font_light_color')['primary'],
                'element' => '.rt-widget--footer .rt-widget__title',
                'output' => [
                    [
                        'element' => '.page-footer__widget',
                        'property' => '--theme-font-color-primary',
                    ],
                ],

            ]);

            $this->add_field_color([
                'settings' => 'footer_widget_background',
                'label' => __('Background Color', RT_THEME_DOMAIN),
                'default' => rt_get_theme('global_background_dark'),
                'section' => $section,
                'output' => [
                    [
                        'element' => '.page-footer__widget',
                        'property' => '--theme-background-primary',
                    ],
                    [
                        'element' => '.page-footer__widget',
                        'property' => '--theme-border-color',
                    ],
                ],
            ]);

            $this->add_field_color([
                'settings' => 'footer_widget_color',
                'label' => __('Content Color', RT_THEME_DOMAIN),
                'section' => $section,
                'pseudo' => 'hover',
                'default' => [
                    'normal' => rt_get_theme('global_font_light_color')['secondary'],
                    'hover' => '#ffffff',
                ],
                'output' => [
                    [
                        'choice' => 'normal',
                        'element' => '.page-footer__widget',
                        'property' => '--theme-font-color-secondary',
                    ],
                    [
                        'choice' => 'normal',
                        'element' => '.page-footer__widget',
                        'property' => '--theme-color-link',
                    ],
                    [
                        'choice' => 'hover',
                        'element' => '.page-footer__widget',
                        'property' => '--theme-color-link-active',
                    ],
                ],

            ]);

        } else {
            $this->add_field([
                'type' => 'radio-image',
                'section' => $section,
                'settings' => 'footer_widget_layout',
                'label' => __('Layout', RT_THEME_DOMAIN),
                'default' => 'footer-1',
                'choices' => [
                    'footer-1' => get_template_directory_uri() . '/core/customizer/assets/img/footer-1.png',
                    'footer-2' => get_template_directory_uri() . '/core/customizer/assets/img/footer-2.png',
                ],
            ]);
        }

    }

    public function add_option_bottom()
    {
        $section = 'footer_bottom_section';
        if (rt_is_premium()) {
            $this->add_field([
                'type' => 'toggle',
                'settings' => 'footer_bottom',
                'label' => __('Enable Footer Bottom', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => true,
            ]);

            $this->add_field([
                'type' => 'sortable',
                'settings' => 'footer_bottom_element',
                'label' => __('Element', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => [
                    'html-1',
                ],
                'choices' => [
                    'social' => __('Social Media', RT_THEME_DOMAIN),
                    'spacer-1' => __('Spacer 1', RT_THEME_DOMAIN),
                    'spacer-2' => __('Spacer 2', RT_THEME_DOMAIN),
                    'html-1' => __('Copyright', RT_THEME_DOMAIN),
                    'image-1' => __('Image', RT_THEME_DOMAIN),
                ],

            ]);

            $this->add_field([
                'type' => 'radio-buttonset',
                'settings' => 'footer_bottom_position',
                'label' => __('Position', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => 'space-between',
                'choices' => [
                    'space-between' => '<i class="fas fa-align-justify"></i>',
                    'left' => '<i class="fas fa-align-left"></i>',
                    'center' => '<i class="fas fa-align-center"></i>',
                    'right' => '<i class="fas fa-align-right"></i>',
                ],
                'transport' => 'auto',
                'default' => 'left',
                'output' => [
                    [
                        'element' => '.page-footer__bottom .page-container',
                        'property' => 'justify-content',
                    ],
                ],

            ]);

            $this->add_field([
                'label' => __('Copyright (Support HTML tag)', RT_THEME_DOMAIN),
                'settings' => "footer_bottom_text",
                'description' => __('You can use text map {{site_name}} {{year}}', RT_THEME_DOMAIN),
                'section' => $section,
                "default" => "@Copyright {{site_name}}. All Rights Reserved",
                'type' => 'textarea',
            ]);

            $this->add_field([
                'type' => 'image',
                'settings' => "footer_bottom_img_1",
                'section' => $section,
                'label' => __('Image', RT_THEME_DOMAIN),
                'description' => __('You can upload image like payment logo, secure logo etc', RT_THEME_DOMAIN),
            ]);

            $this->add_field_color([
                'settings' => 'footer_option_bottom_color',
                'section' => $section,
                'default' => rt_get_theme('global_font_light_color')['secondary'],
                'output' => [
                    [
                        'choose' => 'normal',
                        'element' => '.page-footer__bottom',
                        'property' => '--theme-font-color-secondary',
                    ],
                    [
                        'choose' => 'normal',
                        'element' => '.page-footer__bottom',
                        'property' => '--theme-color-link',
                    ],
                    [
                        'choose' => 'hover',
                        'element' => '.page-footer__bottom',
                        'property' => '--theme-color-link-active',
                    ],
                ],
            ]);

            $this->add_field_background([
                'settings' => 'footer_option_bottom_background',
                'default' => rt_get_theme('global_background_dark'),
                'section' => $section,
                'output' => [
                    [
                        'element' => '.page-footer__bottom',
                        'property' => '--theme-background-primary',
                    ],
                ],
            ]);

            $this->add_field_border_color([
                'settings' => 'footer_option_bottom_border_color',
                'default' => 'rgba(255,255,255,0.06)',
                'section' => $section,
                'output' => [
                    [
                        'element' => '.page-footer__bottom',
                        'property' => '--theme-border-color',
                    ],
                ],
            ]);

        }

    }
// end class
}

new Footer;
