<?php
namespace Retheme\Customizer;

use Retheme\Customizer_Base;

class Customizer extends Customizer_Base
{
    public function __construct()
    {
        \Kirki::add_config('retheme_customizer', array(
            'capability' => 'edit_theme_options',
            'option_type' => 'theme_mod',
        ));

        add_action('customize_controls_enqueue_scripts', [$this, 'retheme_customizer_control'], 999);
        add_action('customize_preview_init', [$this, 'register_customizer_preview']);
        add_action('init', [$this, 'include_part']);

    }

    public function include_part()
    {
        /**
         * Filter customizer section
         */
        $customizers = array(
            'general',
            'header',
            'blog',
            'footer',
            'brand',
            'page',
            'search',
            'connect',
            'homepage',
            'tweak',
        );

        /** custom control */
        include dirname(__FILE__) . '/control/builder/builder.php';

        foreach ($customizers as $key => $customizer) {
            include dirname(__FILE__) . "/{$customizer}.php";
        }

        if (rt_is_woocommerce()) {
            include dirname(__FILE__) . '/woocommerce.php';
        }

    }

    public function retheme_customizer_control()
    {
        // Font Awesome
        wp_enqueue_style('fontawesome', get_template_directory_uri() . '/assets/fontawesome/css/all.min.css', false, '5.14.0');
        wp_enqueue_style('retheme-customizer-panel', get_template_directory_uri() . '/core/customizer/assets/css/customizer-panel.css', false, '2.1.0');

        wp_enqueue_script('retheme-customizer-control', get_template_directory_uri() . '/core/customizer/assets/js/customizer-control.js', array('jquery'), '2.0.0', true);
        wp_enqueue_script('retheme-header-control', get_template_directory_uri() . '/core/customizer/assets/js/header-control.js', array('jquery'), '2.0.0', true);
    }

    public function register_customizer_preview()
    {
        wp_enqueue_style('retheme-customizer-preview', get_template_directory_uri() . '/core/customizer/assets/css/customizer-preview.css', false, '2.0.0');
        wp_enqueue_script('retheme-customizer-preview', get_template_directory_uri() . '/core/customizer/assets/js/customizer-preview.js', array('jquery', 'animate', 'retheme'), '2.0.0', true);
    }

    /**
     * Backup after customizer save
     *
     */
    public function backup_customizer()
    {
        $current_theme = str_replace(' ', '-', strtolower(get_option('current_theme')));
        update_option("theme_mods_{$current_theme}_backup", get_option("theme_mods_{$current_theme}"));

    }
    // end class
}

new Customizer;
