<?php

/**
 * @author : Reret
 */

namespace Retheme\Customizer;

use Retheme\Customizer_Base;

class Brand extends Customizer_Base
{

    public function __construct()
    {

        $this->add_brand_logo();
    }

    public function add_brand_logo()
    {
        $section = 'title_tagline';

        $this->add_header([
            'label' => __('Desktop Logo', RT_THEME_DOMAIN),
            'settings' => 'brand_logo',
            'section' => $section,
            'partial_refresh'    => [
                'brand_logo' => [
                    'selector'        => '.rt-header .rt-logo',
                    'render_callback' => function() {
                        return false;
                    },
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'image',
            'settings' => 'brand_logo_primary',
            'label' => __('Default Logo', RT_THEME_DOMAIN),
            'description' => __('This logo will be used as your default logo on desktop device', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'slider',
            'settings' => 'brand_logo_primary_size',
            'label' => __('Default Logo Width', RT_THEME_DOMAIN),
            'section' => $section,
            'choices' => [
                'min' => '10',
                'max' => '300',
                'step' => '1',
            ],
            'default' => '180',
            'output' => [
                [
                    'element' => '.rt-header__main .rt-logo,
                                 .rt-header__middle .rt-logo',
                    'property' => 'width',
                    'units' => 'px',
                ],

            ],
            'transport' => 'auto',
        ]);

        if (rt_is_premium()) {
            $this->add_field([
                'type' => 'image',
                'settings' => 'brand_logo_sticky',
                'label' => __('Sticky Logo', RT_THEME_DOMAIN),
                'description' => __('This logo will be used when the header is in a sticky state.', RT_THEME_DOMAIN),
                'section' => $section,
            ]);

            $this->add_field([
                'type' => 'slider',
                'settings' => 'brand_logo_sticky_size',
                'label' => __('Sticky Logo Width', RT_THEME_DOMAIN),
                'section' => $section,
                'choices' => [
                    'min' => '10',
                    'max' => '300',
                    'step' => '1',
                ],
                'default' => '180',
                'output' => [
                    [
                        'element' => '.rt-header__sticky .rt-logo',
                        'property' => 'width',
                        'units' => 'px',
                    ],

                ],
                'transport' => 'auto',
            ]);
        }

        $this->add_header([
            'label' => __('Mobile Logo', RT_THEME_DOMAIN),
            'settings' => 'brand_logo_mobile',
            'section' => $section,
            'partial_refresh'    => [
                'brand_logo_mobile' => [
                    'selector'        => '.rt-header-mobile .rt-logo',
                    'render_callback' => function() {
                        return false;
                    },
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'image',
            'settings' => 'brand_logo_mobile',
            'label' => __('Mobile Logo', RT_THEME_DOMAIN),
            'description' => __('This logo will be used on mobile devices', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'slider',
            'settings' => 'brand_logo_mobile_size',
            'label' => __('Mobile Logo Width', RT_THEME_DOMAIN),
            'section' => $section,
            'choices' => [
                'min' => '10',
                'max' => '200',
                'step' => '1',
            ],
            'default' => '180',
            'output' => [
                [
                    'element' => '.rt-header-mobile__main .rt-logo',
                    'property' => 'width',
                    'units' => 'px',
                ],

            ],
            'transport' => 'auto',
        ]);

        if (rt_is_premium()) {
            $this->add_header([
                'label' => __('Checkout Logo', RT_THEME_DOMAIN),
                'settings' => 'focus_logo',
                'section' => $section,
            ]);

            $this->add_field([
                'type' => 'image',
                'settings' => 'focus_logo_primary',
                'label' => __('Checkout Logo', RT_THEME_DOMAIN),
                'description' => __('This logo will be used on checkout template', RT_THEME_DOMAIN),
                'section' => $section,
            ]);

            $this->add_field([
                'type' => 'slider',
                'settings' => 'focus_logo_primary_size',
                'label' => __('Checkout Logo Width', RT_THEME_DOMAIN),
                'section' => $section,
                'choices' => [
                    'min' => '10',
                    'max' => '300',
                    'step' => '1',
                ],
                'default' => '180',
                'output' => [
                    [
                        'element' => '.ptf-header .rt-logo',
                        'property' => 'width',
                        'units' => 'px',
                    ],

                ],
                'transport' => 'auto',
            ]);
        }

        $this->add_header([
            'label' => __('Alternative Desktop Logo', RT_THEME_DOMAIN),
            'settings' => 'brand_logo_overlay',
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'image',
            'settings' => 'brand_logo_overlay',
            'label' => __('Alternative Logo', RT_THEME_DOMAIN),
            'description' => __('This logo will be used as your default logo on transparent header', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'slider',
            'settings' => 'brand_logo_overlay_size',
            'label' => __('Alternative Desktop Logo Width', RT_THEME_DOMAIN),
            'section' => $section,
            'choices' => [
                'min' => '10',
                'max' => '300',
                'step' => '1',
            ],
            'default' => '180',
            'output' => [
                [
                    'element' => '.is-overlay .rt-header__main .rt-logo',
                    'property' => 'width',
                    'units' => 'px',
                ],

            ],
            'transport' => 'auto',
        ]);

        $this->add_header([
            'label' => __('Alternative Mobile Logo', RT_THEME_DOMAIN),
            'settings' => 'brand_logo_overlay_mobile',
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'image',
            'settings' => 'brand_logo_mobile_overlay',
            'label' => __('Alternative Mobile Logo', RT_THEME_DOMAIN),
            'description' => __('This logo will be used as your mobile logo on transparent header', RT_THEME_DOMAIN),
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'slider',
            'settings' => 'brand_logo_mobile_overlay_size',
            'label' => __('Alternative Mobile Logo Width', RT_THEME_DOMAIN),
            'section' => $section,
            'choices' => [
                'min' => '10',
                'max' => '300',
                'step' => '1',
            ],
            'default' => '180',
            'output' => [
                [
                    'element' => '.is-overlay .rt-header-mobile__main .rt-logo',
                    'property' => 'width',
                    'units' => 'px',
                ],

            ],
            'transport' => 'auto',
        ]);

        $this->add_header([
            'label' => __('Color Browser', RT_THEME_DOMAIN),
            'settings' => 'brand_color_browser',
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'color',
            'label' => __('Color Browser', RT_THEME_DOMAIN),
            'settings' => 'brand_color_browser',
            'description' => __('Change the Color of Address Bar in Mobile Browser', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => $this->get_default_mod('global_brand_color', 'primary'),
        ]);

        $this->add_header([
            'label' => __('Pavicon', RT_THEME_DOMAIN),
            'settings' => 'brand_pavicon',
            'section' => $section,
        ]);
    }

    // end class
}

new Brand;
