<?php

/**
 * @author : Reret
 */

namespace Retheme\Customizer;

use Retheme\Customizer_Base;

class Blog extends Customizer_Base
{
    public function __construct()
    {
        $this->set_panel();
        $this->set_section();

        // archive section
        $this->add_blog_options();
        $this->add_blog_layout();
        $this->add_blog_styles();

        // single section
        $this->add_single_options();
        $this->add_single_related();
        $this->add_single_layout();

        // element
        $this->add_element_label();
    }

    public function set_panel()
    {
        $this->add_panel('blog_panel', [
            'title' => __('Blog', RT_THEME_DOMAIN),
        ]);
    }

    public function set_section()
    {
        $this->add_section('blog_panel', [
            'blog_archive' => [__('Blog Archive', RT_THEME_DOMAIN)],
            'blog_single' => [__('Blog Single', RT_THEME_DOMAIN)],
            'blog_label' => [__('Label', RT_THEME_DOMAIN)],
        ]);
    }

    public function add_blog_options()
    {
        $section = 'blog_archive_section';

        $this->add_header([
            'label' => __('Options', RT_THEME_DOMAIN),
            'settings' => 'blog_archive',
            'section' => $section,
        ]);
        
        if (rt_is_premium()) {
            $this->add_field([
                'type' => 'radio-image',
                'settings' => 'blog_archive_style',
                'label' => __('Style', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => 'grid',
                'choices' => [
                    'grid' => get_template_directory_uri() . '/core/customizer/assets/img/post-grid.png',
                    'list' => get_template_directory_uri() . '/core/customizer/assets/img/post-list.png',
                ],
            ]);

            $this->add_field([
                'type' => 'toggle',
                'settings' => 'blog_archive_masonry',
                'label' => __('Masonry', RT_THEME_DOMAIN),
                'description' => __('Grid layout with different height', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => false,
                'active_callback' => [
                    [
                        'setting' => 'blog_archive_style',
                        'operator' => '==',
                        'value' => 'grid',
                    ],
                ],
            ]);

            $this->add_field([
                'type' => 'toggle',
                'settings' => 'blog_archive_card',
                'label' => __('Blog Card frame', RT_THEME_DOMAIN),
                'description' => __('When enabled, show a border around Product Cards.', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => false,
                'active_callback' => [
                    [
                        'setting' => 'blog_archive_style',
                        'operator' => '==',
                        'value' => 'grid',
                    ],
                ],
            ]);

            $this->add_field_responsive([
                'type' => 'slider',
                'section' => $section,
                'settings' => 'blog_archive_column',
                'label' => __('Column', RT_THEME_DOMAIN),
                'description' => __('Number of Column Per Row', RT_THEME_DOMAIN),
                'default' => 3,
                'default_tablet' => 2,
                'default_mobile' => 2,
                'choices' => [
                    'min' => 1,
                    'max' => 6,
                ],
                'active_callback' => [
                    [
                        'setting' => 'blog_archive_style',
                        'operator' => '==',
                        'value' => 'grid',
                    ],
                ],
            ]);

            $this->add_field([
                'type' => 'number',
                'section' => $section,
                'settings' => 'blog_archive_excerpt',
                'label' => __('Excerpt', RT_THEME_DOMAIN),
                'description' => __('Set word length of excerpt on post', RT_THEME_DOMAIN),
                'default' => 18,
                'choices' => [
                    'min' => 0,
                    'max' => 50,
                ],
            ]);

            $this->add_field([
                'type' => 'select',
                'settings' => 'blog_archive_pagination',
                'label' => __('Pagination', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => 'number',
                'multiple' => 1,
                'choices' => [
                    'none' => __('None', RT_THEME_DOMAIN),
                    'number' => __('Number', RT_THEME_DOMAIN),
                    'loadmore' => __('Load More', RT_THEME_DOMAIN),
                ],
            ]);
        }

        $this->add_field([
            'type' => 'multicheck',
            'settings' => 'blog_element',
            'label' => __('Blog Elements', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'category', 'thumbnail', 'content', 'readmore',
            ],
            'multiple' => 999,
            'choices' => [
                'category' => __('Category', RT_THEME_DOMAIN),
                'thumbnail' => __('Featured Image', RT_THEME_DOMAIN),
                'content' => __('Content', RT_THEME_DOMAIN),
                'readmore' => __('Read More', RT_THEME_DOMAIN),
            ],
        ]);

        $this->add_field([
            'type' => 'multicheck',
            'settings' => 'blog_meta',
            'label' => __('Blog Meta', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'meta-author', 'meta-date', 'meta-comment',
            ],
            'multiple' => 999,
            'choices' => [
                'meta-author' => __('Author', RT_THEME_DOMAIN),
                'meta-date' => __('Date', RT_THEME_DOMAIN),
                'meta-comment' => __('Comment', RT_THEME_DOMAIN),
            ],
        ]);
    }

    public function add_blog_layout()
    {
        $section = 'blog_archive_section';

        $this->add_header([
            'label' => __('Blog Archive Layout', RT_THEME_DOMAIN),
            'settings' => 'blog_archive_layout',
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'radio-image',
            'settings' => 'blog_archive_layout',
            'label' => __('Layout', RT_THEME_DOMAIN),
            'description' => sprintf(__('Visit the <a href="%s">Widgets panel</a> and add widget to display a element in a sidebar.', RT_THEME_DOMAIN), "javascript:wp.customize.panel( 'widgets' ).focus();"),
            'section' => $section,
            'default' => 'sidebar-right',
            'choices' => [
                'normal' => get_template_directory_uri() . '/core/customizer/assets/img/layout-normal.png',
                'compact' => get_template_directory_uri() . '/core/customizer/assets/img/layout-compact.png',
                'sidebar-left' => get_template_directory_uri() . '/core/customizer/assets/img/layout-sidebar-left.png',
                'sidebar-right' => get_template_directory_uri() . '/core/customizer/assets/img/layout-sidebar-right.png',
            ],
        ]);
    }

    public function add_blog_styles()
    {
        if (rt_is_advanced()) {
            $section = 'blog_archive_section';

            $this->add_header([
                'label' => __('Styles', RT_THEME_DOMAIN),
                'settings' => 'blog_advanced_style',
                'section' => $section,
            ]);

            $this->add_field([
                'settings' => 'blog_archive_title_background',
                'type' => 'color',
                'label' => __('Content Background', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => $this->get_default_mod('global_background_scheme', 'primary'),
                'output' => [
                    [
                        'element' => '.rt-post--card',
                        'property' => 'background-color',
                    ],
                ],
                'transport' => 'auto',
                'active_callback' => [
                    [
                        'setting' => 'blog_archive_card',
                        'operator' => '==',
                        'value' => true,
                    ],
                ],
            ]);

            $this->add_field([
                'settings' => 'blog_archive_title_color',
                'type' => 'color',
                'label' => __('Title Color', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => $this->get_default_mod('global_font_color', 'primary'),
                'output' => [
                    [
                        'element' => '.rt-post--card .rt-post__title a:not(:hover)',
                        'property' => 'color',
                        'suffix' => '!important',
                    ],
                ],
                'transport' => 'auto',
            ]);

            $this->add_field([
                'settings' => 'blog_archive_meta_color',
                'type' => 'color',
                'label' => __('Title Color', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => $this->get_default_mod('global_font_color', 'secondary'),
                'output' => [
                    [
                        'element' => '.rt-post--card .rt-post__meta-item',
                        'suffix' => '!important',
                    ],
                ],
                'transport' => 'auto',
            ]);

            $this->add_field([
                'settings' => 'blog_archive_content_color',
                'type' => 'color',
                'label' => __('Title Color', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => $this->get_default_mod('global_font_color', 'tertiary'),
                'output' => [
                    [
                        'element' => '.flex-loop .rt-post .rt-post__content,
                                    .rt-swiper .rt-post .rt-post__content',
                    ],
                ],
                'transport' => 'auto',
            ]);
        }
    }

    public function add_single_options()
    {
        $section = 'blog_single_section';

        $this->add_header([
            'label' => __('Options', RT_THEME_DOMAIN),
            'settings' => 'blog_single_title_align',
            'section' => $section,
        ]);
        if (rt_is_premium()) {
            $this->add_field([
                'type' => 'radio-buttonset',
                'settings' => 'blog_single_title_align',
                'label' => __('Post Title Align', RT_THEME_DOMAIN),
                'section' => $section,
                'default' => 'center',
                'choices' => [
                    'left' => '<i class="fas fa-align-left"></i>',
                    'center' => '<i class="fas fa-align-center"></i>',
                    'right' => '<i class="fas fa-align-right"></i>',
                ],
                'transport' => 'auto',
                'output' => [
                    [
                        'element' => '.rt-single__title, .rt-single__meta',
                        'property' => 'text-align',
                        'value_pattern' => '$',
                    ],
                    [
                        'choice' => 'center',
                        'element' => '.single-post .rt-breadcrumbs, .single-post .rt-share',
                        'property' => 'display',
                        'value_pattern' => 'flex',
                    ],
                    [
                        'choice' => 'center',
                        'element' => '.single-post .rt-breadcrumbs, .single-post .rt-share',
                        'property' => 'justify-content',
                        'value_pattern' => '$',
                    ],
                ],
            ]);
        }

        $this->add_field([
            'type' => 'multicheck',
            'settings' => 'single_element',
            'label' => __('Single Elements', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'thumbnail', 'tag', 'authorbox', 'navigation', 'comment', 'related',
            ],
            'multiple' => 999,
            'choices' => [
                'thumbnail' => __('Featured Image', RT_THEME_DOMAIN),
                'tag' => __('Tags', RT_THEME_DOMAIN),
                'authorbox' => __('Author Box', RT_THEME_DOMAIN),
                'navigation' => __('Navigation', RT_THEME_DOMAIN),
                'comment' => __('Comment', RT_THEME_DOMAIN),
                'related' => __('Related Posts', RT_THEME_DOMAIN),
            ],
        ]);

        $this->add_field([
            'type' => 'multicheck',
            'settings' => 'single_meta',
            'label' => __('Single Meta', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => [
                'meta-author', 'meta-date', 'meta-category',
            ],
            'multiple' => 999,
            'choices' => [
                'meta-author' => __('Author', RT_THEME_DOMAIN),
                'meta-date' => __('Date', RT_THEME_DOMAIN),
                'meta-category' => __('Category', RT_THEME_DOMAIN),
            ],
        ]);
    }

    public function add_single_related()
    {

        $section = 'blog_single_section';

        $this->add_header([
            'label' => __('Related', RT_THEME_DOMAIN),
            'settings' => 'single_related',
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'number',
            'settings' => 'single_related_count',
            'label' => __('Total Number of Related Posts', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => 6,
        ]);

        $this->add_field_responsive([
            'type' => 'slider',
            'settings' => 'single_related_show',
            'label' => __('Slides Per View', RT_THEME_DOMAIN),
            'section' => $section,
            'default' => 3,
            'default_tablet' => 2,
            'default_mobile' => 2,
            'choices' => [
                'min' => 1,
                'max' => 6,
            ],
        ]);
    }

    public function add_single_layout()
    {
        $section = 'blog_single_section';

        $this->add_header([
            'label' => __('Blog Single Layout', RT_THEME_DOMAIN),
            'settings' => 'blog_single_layout',
            'section' => $section,

        ]);
        $this->add_field([
            'type' => 'radio-image',
            'settings' => 'blog_single_layout',
            'label' => __('Layout', RT_THEME_DOMAIN),
            'description' => sprintf(__('Visit the <a href="%s">Widgets panel</a> and add widget to display a element in a sidebar.', RT_THEME_DOMAIN), "javascript:wp.customize.panel( 'widgets' ).focus();"),
            'section' => $section,
            'default' => 'sidebar-right',
            'choices' => [
                'normal' => get_template_directory_uri() . '/core/customizer/assets/img/layout-normal.png',
                'compact' => get_template_directory_uri() . '/core/customizer/assets/img/layout-compact.png',
                'sidebar-left' => get_template_directory_uri() . '/core/customizer/assets/img/layout-sidebar-left.png',
                'sidebar-right' => get_template_directory_uri() . '/core/customizer/assets/img/layout-sidebar-right.png',
            ],
        ]);
    }

    /**
     * Blog element
     */
    public function add_element_label()
    {
        $section = 'blog_label_section';
        if (rt_is_premium()) {
            $this->add_field_color([
                'settings' => "blog_badges_color",
                'section' => $section,
                'pseudo' => 'hover',
                'default' => [
                    'normal' => '#ffffff',
                    'hover' => '#ffffff',
                ],
                'element' => '.rt-post .rt-badges a, .rt-single .rt-badges a',
                'suffix' => '!important',
            ]);

            $this->add_field_background([
                'settings' => 'blog_badges_background',
                'section' => $section,
                'pseudo' => 'hover',
                'default' => [
                    'normal' => $this->get_default_mod('global_brand_color', 'primary'),
                    'hover' => $this->get_default_mod('global_brand_color', 'secondary'),
                ],
                'element' => '.rt-post .rt-badges a, .rt-single .rt-badges a',

            ]);
        }
    }

    // end class
}

new Blog;
