<?php
/**
 * Generate PHP Field from ACF
 *
 * @param [type] $categories
 * @param [type] $post
 * @return void
 */
function rt_acf_add_local_field_group()
{
    if (function_exists('acf_add_local_field_group')){

        acf_add_local_field_group(array(
            'key' => 'group_60b396700711c',
            'title' => 'Image Slides',
            'fields' => array(
                array(
                    'key' => 'field_6176a165597a1',
                    'label' => 'Slides',
                    'name' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_60b3b2544fc31',
                    'label' => 'Image',
                    'name' => 'slides',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'collapsed' => '',
                    'min' => 1,
                    'max' => 10,
                    'layout' => 'table',
                    'button_label' => 'Add Slide',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_60b3b2904fc32',
                            'label' => 'Image',
                            'name' => 'image',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'id',
                            'preview_size' => 'medium',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                        ),
                        array(
                            'key' => 'field_60b3b2a34fc33',
                            'label' => 'Url',
                            'name' => 'url',
                            'type' => 'url',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6176a17d597a2',
                    'label' => 'Options',
                    'name' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_61769ea4ac745',
                    'label' => 'Slides to Show On Desktop',
                    'name' => 'slider_show',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 1,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_61769f0338778',
                    'label' => 'Slides to Show On Tablet',
                    'name' => 'slider_show_tablet',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 1,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_61769ef638777',
                    'label' => 'Slides to Show On Mobile',
                    'name' => 'slider_show_mobile',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 1,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60b396701b80b',
                    'label' => 'Infinite Loop',
                    'name' => 'slider_loop',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60b396701b832',
                    'label' => 'Auto Play',
                    'name' => 'slider_autoplay',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'block',
                        'operator' => '==',
                        'value' => 'acf/retheme-slider',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
        ));

        acf_add_local_field_group(array(
            'key' => 'group_60cb37631b379',
            'title' => 'Post',
            'fields' => array(
                array(
                    'key' => 'field_60cb37632c0ed',
                    'label' => 'Query',
                    'name' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_60cb37632c0fb',
                    'label' => 'Query Post by',
                    'name' => 'query_by',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'lastest' => 'Lastest Posts',
                        'featured' => 'Featured Posts',
                        'category' => 'Categories',
                        'manually' => 'Hand Picks\'',
                    ),
                    'default_value' => 'lastest',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_60cb37632c108',
                    'label' => 'Category',
                    'name' => 'category',
                    'type' => 'taxonomy',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c0fb',
                                'operator' => '==',
                                'value' => 'category',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'taxonomy' => 'category',
                    'field_type' => 'multi_select',
                    'allow_null' => 0,
                    'add_term' => 1,
                    'save_terms' => 0,
                    'load_terms' => 0,
                    'return_format' => 'id',
                    'multiple' => 0,
                ),
                array(
                    'key' => 'field_60cb37632c115',
                    'label' => 'Select Post',
                    'name' => 'post_id',
                    'type' => 'post_object',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c0fb',
                                'operator' => '==',
                                'value' => 'manually',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'post_type' => array(
                        0 => 'post',
                    ),
                    'taxonomy' => '',
                    'allow_null' => 0,
                    'multiple' => 1,
                    'return_format' => 'id',
                    'ui' => 1,
                ),
                array(
                    'key' => 'field_60cb37632c122',
                    'label' => 'Order By',
                    'name' => 'order_by',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'ID' => 'Post Id',
                        'author' => 'Post Author',
                        'title' => 'Title',
                        'date' => 'Date',
                        'modified' => 'Last Modified Date',
                        'comment_count' => 'Most Review',
                    ),
                    'default_value' => 'date',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_60cb37632c12f',
                    'label' => 'Posts Per Page',
                    'name' => 'posts_per_page',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 9,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => '',
                    'max' => '',
                    'step' => '',
                ),
                array(
                    'key' => 'field_60cb37632c03a',
                    'label' => 'Options',
                    'name' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_60cb37632c05e',
                    'label' => 'Carousel',
                    'name' => 'carousel',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60cb37632c06b',
                    'label' => 'Slides to Show On Desktop',
                    'name' => 'slider_show',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c05e',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 4,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60cb37632c078',
                    'label' => 'Slides to Show On Tablet',
                    'name' => 'slider_show_tablet',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c05e',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60cb37632c085',
                    'label' => 'Slides to Show On Mobile',
                    'name' => 'slider_show_mobile',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c05e',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60cb37632c091',
                    'label' => 'Link Action',
                    'name' => 'slider_link',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c05e',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60cb37632c09e',
                    'label' => 'Column On Desktop',
                    'name' => 'column',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c05e',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 4,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60cb37632c0ab',
                    'label' => 'Column On Tablet',
                    'name' => 'column_tablet',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c05e',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60cb37632c0b9',
                    'label' => 'Column On Mobile',
                    'name' => 'column_mobile',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c05e',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60cb37632c0c6',
                    'label' => 'Pagination Style',
                    'name' => 'pagination',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c05e',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'none' => 'None',
                        'loadmore' => 'Load More',
                        'link' => 'Link',
                    ),
                    'default_value' => false,
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_60cb37632c0d3',
                    'label' => 'Link Text',
                    'name' => 'link_text',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c091',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                        array(
                            array(
                                'field' => 'field_60cb37632c0c6',
                                'operator' => '==',
                                'value' => 'link',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_60cb37632c0e0',
                    'label' => 'Link Url',
                    'name' => 'link_url',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60cb37632c091',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                        array(
                            array(
                                'field' => 'field_60cb37632c0c6',
                                'operator' => '==',
                                'value' => 'link',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'block',
                        'operator' => '==',
                        'value' => 'acf/retheme-post',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
        ));

        acf_add_local_field_group(array(
            'key' => 'group_60b38b759abbc',
            'title' => 'Product',
            'fields' => array(
                array(
                    'key' => 'field_60b39302297ec',
                    'label' => 'Query',
                    'name' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_60b38f531d986',
                    'label' => 'Query Products by',
                    'name' => 'query_by',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'lastest' => 'Lastest Products',
                        'featured' => 'Featured Products',
                        'category' => 'Categories',
                        'manually' => 'Hand Picks\'',
                    ),
                    'default_value' => 'lastest',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_60b390121d988',
                    'label' => 'Select Products',
                    'name' => 'post_id',
                    'type' => 'post_object',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38f531d986',
                                'operator' => '==',
                                'value' => 'manually',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'post_type' => array(
                        0 => 'product',
                    ),
                    'taxonomy' => '',
                    'allow_null' => 0,
                    'multiple' => 1,
                    'return_format' => 'id',
                    'ui' => 1,
                ),
                array(
                    'key' => 'field_60b38fc01d987',
                    'label' => 'Category',
                    'name' => 'category',
                    'type' => 'taxonomy',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38f531d986',
                                'operator' => '==',
                                'value' => 'category',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'taxonomy' => 'product_cat',
                    'field_type' => 'multi_select',
                    'allow_null' => 0,
                    'add_term' => 1,
                    'save_terms' => 0,
                    'load_terms' => 0,
                    'return_format' => 'id',
                    'multiple' => 0,
                ),
                array(
                    'key' => 'field_60b390911d989',
                    'label' => 'Order By',
                    'name' => 'order_by',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'ID' => 'Post Id',
                        'author' => 'Post Author',
                        'title' => 'Title',
                        'date' => 'Date',
                        'modified' => 'Last Modified Date',
                        'total_sales' => 'Most Selling',
                        'wp_post_views_count' => 'Most Viewer',
                        'comment_count' => 'Most Review',
                    ),
                    'default_value' => 'date',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_60b391381d98a',
                    'label' => 'Posts Per Page',
                    'name' => 'posts_per_page',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 9,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => '',
                    'max' => '',
                    'step' => '',
                ),
                array(
                    'key' => 'field_60b392c0297eb',
                    'label' => 'Options',
                    'name' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_60b38b84e2398',
                    'label' => 'Carousel',
                    'name' => 'carousel',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60b38bb2e2399',
                    'label' => 'Slides to Show On Desktop',
                    'name' => 'slider_show',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38b84e2398',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 4,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60b38ca2c87e6',
                    'label' => 'Slides to Show On Tablet',
                    'name' => 'slider_show_tablet',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38b84e2398',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60b38cbdc87e7',
                    'label' => 'Slides to Show On Mobile',
                    'name' => 'slider_show_mobile',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38b84e2398',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60b38ce5c87e8',
                    'label' => 'Link Action',
                    'name' => 'slider_link',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38b84e2398',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60b38e32c87ea',
                    'label' => 'Column On Desktop',
                    'name' => 'column',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38b84e2398',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 4,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60b38e95c87eb',
                    'label' => 'Column On Tablet',
                    'name' => 'column_tablet',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38b84e2398',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60b38ea9c87ec',
                    'label' => 'Column On Mobile',
                    'name' => 'column_mobile',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38b84e2398',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60b38eec1d985',
                    'label' => 'Pagination Style',
                    'name' => 'pagination',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38b84e2398',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'none' => 'None',
                        'loadmore' => 'Load More',
                        'link' => 'Link',
                    ),
                    'default_value' => false,
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_60c95d953a4f1',
                    'label' => 'Link Text',
                    'name' => 'link_text',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38ce5c87e8',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                        array(
                            array(
                                'field' => 'field_60b38eec1d985',
                                'operator' => '==',
                                'value' => 'link',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_60c95db73a4f2',
                    'label' => 'Link Url',
                    'name' => 'link_url',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b38ce5c87e8',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                        array(
                            array(
                                'field' => 'field_60b38eec1d985',
                                'operator' => '==',
                                'value' => 'link',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'block',
                        'operator' => '==',
                        'value' => 'acf/retheme-product',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
        ));

        acf_add_local_field_group(array(
            'key' => 'group_60b3944e46078',
            'title' => 'Product Categories',
            'fields' => array(
                array(
                    'key' => 'field_60b3945e25593',
                    'label' => 'Style',
                    'name' => 'style',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'style-1' => 'Style 1',
                        'style-2' => 'Style 2',
                    ),
                    'default_value' => 'style-1',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_60b3949325594',
                    'label' => 'Hide Empty Category',
                    'name' => 'hide_empty',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60b394cf25595',
                    'label' => 'Slides to Show on Desktop',
                    'name' => 'slider_show',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b3945e25593',
                                'operator' => '==',
                                'value' => 'style-1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 4,
                    'min' => 1,
                    'max' => 6,
                    'step' => 1,
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60b3951a25596',
                    'label' => 'Slides to Show on Tablet',
                    'name' => 'slider_show_tablet',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b3945e25593',
                                'operator' => '==',
                                'value' => 'style-1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 1,
                    'max' => 6,
                    'step' => 1,
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60b3954125597',
                    'label' => 'Slides to Show on Mobile',
                    'name' => 'slider_show_mobile',
                    'type' => 'range',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60b3945e25593',
                                'operator' => '==',
                                'value' => 'style-1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 1,
                    'max' => 6,
                    'step' => 1,
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60b395d425599',
                    'label' => 'Infinite Loop',
                    'name' => 'slider_loop',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60b3959225598',
                    'label' => 'Auto Play',
                    'name' => 'slider_autoplay',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'block',
                        'operator' => '==',
                        'value' => 'acf/retheme-product-cat',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
        ));
    }

}
add_action('acf/init', 'rt_acf_add_local_field_group');
/**
 * Register Custom Blocks ACF
 * Register block with acf plugin
 * @return void
 */
function rt_register_blocks()
{
    // Check function exists.
    if (function_exists('acf_register_block_type')) {

        $icon = 'block-default';

        // Product Block
        acf_register_block_type(array(
            'name' => 'retheme-post',
            'title' => __('Post'),
            'render_template' => 'template-parts/block/post.php',
            'category' => 'retheme-blocks',
            'icon' => $icon,
            'keywords' => array('post', 'blog', 'retheme'),
        ));

        // Product Block
        acf_register_block_type(array(
            'name' => 'retheme-product',
            'title' => __('Product'),
            'render_template' => 'template-parts/block/product.php',
            'category' => 'retheme-blocks',
            'icon' => $icon,
            'keywords' => array('product', 'retheme'),
        ));

        // Product Categories
        acf_register_block_type(array(
            'name' => 'retheme-product-cat',
            'title' => __('Product Categories'),
            'render_template' => 'template-parts/block/product-category.php',
            'category' => 'retheme-blocks',
            'icon' => $icon,
            'keywords' => array('product', 'retheme'),
        ));

        // Slider Block
        acf_register_block_type(array(
            'name' => 'retheme-slider',
            'title' => __('Slider'),
            'render_template' => 'template-parts/block/slider.php',
            'category' => 'retheme-blocks',
            'icon' => $icon,
            'keywords' => array('slider', 'retheme'),
        ));
    }
}
add_action('acf/init', 'rt_register_blocks');

/**
 * Creating Custom Block Categories
 *
 * @param [type] $categories
 * @param [type] $post
 * @return void
 */
function rt_register_blocks_category($categories, $post)
{
    $theme = rt_get_theme('product-name');

    return array_merge(
        $categories,
        array(
            array(
                'slug' => 'retheme-blocks',
                'title' => __("{$theme} Blocks", 'retheme-blocks'),
            ),
        )
    );
}
add_filter('block_categories', 'rt_register_blocks_category', 10, 2);



/**
 * Register scripts JS
 * run this function to admin gutenberg editor
 */
function rt_block_editor_scripts()
{
    wp_enqueue_script('swiper', get_template_directory_uri() . '/assets/swiper/swiper.min.js', false, time(), true);
    wp_enqueue_script('masonry', get_template_directory_uri() . '/assets/js/masonry.pkgd.min.js', false, time(), true);
    wp_enqueue_script('retheme-masonry', get_template_directory_uri() . '/assets/js/retheme-masonry.min.js', false, time(), true);
    wp_enqueue_script('retheme-block-editor', get_template_directory_uri() . '/assets/js/block-editor.min.js', false, time(), true);
}
//add_action('enqueue_block_editor_assets', 'rt_block_editor_scripts');

/**
 * Register CSS on Gutenberg editor
 * run this function to admin gutenberg editor
 */
function rt_block_editor_style()
{
    add_editor_style('assets/swiper/swiper.min.css');
    add_editor_style('retheme-icon/styles.min.css');
    add_editor_style('assets/css/masonry.min.css');
    add_editor_style('assets/css/block-editor.min.css');
}
add_action('admin_init', 'rt_block_editor_style');

/**
 * Block editor preview
 *
 * Set default style on Gutenberg editor
 *
 * @param [type] $args set args from the block
 * @return void
 */
function rt_block_editor_preview($args)
{
    $block = wp_parse_args($args, array(
        'title' => 'Block',
    ));

    echo '<div class="rt-block-editor-preview">';
    echo $block['title'];
    echo '</div>';
}

/**
 * Get value form field ACF Blocks Editor
 *
 * @param $value get value
 * @param $default get default value
 */
function rt_get_block_field($value, $default = '')
{
    return (rt_get_field($value)) ? rt_get_field($value) : $default;
}
