/**
 * Show hidden form login and register on modal login WooCommerce
 *
 */
var accountFormLogin = function () {
  const modalLogin = document.querySelector(".js-account-form");

  if (modalLogin == null) {
    return false;
  }

  const triggerLogin = modalLogin.querySelector(".js-account-login");
  const triggerRegister = modalLogin.querySelector(".js-account-register");
  const loginWrappers = modalLogin.querySelectorAll(
    ".rt-form-login, .account-login-title"
  );
  const registerWrappers = modalLogin.querySelectorAll(
    ".rt-form-register, .account-register-title"
  );

  if (triggerLogin !== null) {
    triggerLogin.addEventListener("click", (event) => {
      loginWrappers.forEach((element) => {
        element.style.display = "block";
      });
      registerWrappers.forEach((element) => {
        element.style.display = "none";
      });
    });
  }

  if (triggerRegister !== null) {
    triggerRegister.addEventListener("click", (event) => {
      registerWrappers.forEach((element) => {
        element.style.display = "block";
      });
      loginWrappers.forEach((element) => {
        element.style.display = "none";
      });
    });
  }
};
accountFormLogin();

/**
 * Quantity input with plus/minus button ui
 *
 * @version 2.0.0
 */
function quantityCountInput() {
  document.addEventListener("click", (event) => {
    const trigger = event.target.closest(".rt-qty span");

    if (trigger && document.contains(trigger)) {
      event.preventDefault();

      const qty = trigger.closest(".rt-qty").querySelector(".qty");
      const val = parseFloat(qty.value);
      const max = parseFloat(qty.getAttribute("max"));
      const min = parseFloat(qty.getAttribute("min"));
      const step = parseFloat(qty.getAttribute("step"));

      if (val >= max) {
        qty.style.setProperty("pointer-events", "none");
      } else {
        qty.style.setProperty("pointer-events", "auto");
      }

      // Change the value if plus or minus
      if (trigger.classList.contains("plus")) {
        if (max && max <= val) {
          qty.value = max;
        } else if (isNaN(val) || val == null) {
          qty.value = 1;
        } else {
          qty.value = val + step;
        }
      } else {
        if (min && min >= val) {
          qty.value = min;
        } else if (val > min) {
          qty.value = val - step;
        }
      }
    }
  });
}
quantityCountInput();

/**
 * Set width  orderby select box on shop page
 */
function orderbyWidth() {
  const selectId = document.querySelector(".orderby");

  if (selectId == null) {
    return false;
  }

  const selectedText = selectId.options[selectId.selectedIndex].text;

  // set selected width
  selectId.style.width = selectedText.length * 7 + 40 + "px";
}
orderbyWidth();

/**
 * Show/Hidden password login
 */

function showHiddenPassword() {
  const passwords = document.querySelectorAll('input[type="password"]');

  // add trigger icon each input type password
  passwords.forEach((password) => {
    password.parentNode.innerHTML += '<span class="show-password-input"></span>';
  });
  
}
showHiddenPassword();