class accordion {
  constructor() {
    this.component = ".js-accordion";
    this.item = ".rt-accordion__item";
    this.title = ".rt-accordion__title";
    this.content = ".rt-accordion__content";
    this.toggle = "data-toggle";

    this.open();
  }

  deleteAll() {
    const components = querySelectorAll(this.component);

    components.forEach((component) => {
      const items = component.querySelectorAll(this.item);
      const titles = component.querySelectorAll(this.title);
      const contents = component.querySelectorAll(this.content);

      //hide all component
      items.forEach((element) => {
        element.classList.remove("is-active");
      });
      contents.forEach((element) => {
        element.style.display = "none";
      });
    });
  }

  open() {
    const components = document.querySelectorAll(this.component);

    components.forEach((component) => {
      const items = component.querySelectorAll(this.item);
      const toggle = component.getAttribute(this.toggle);

      items.forEach((item) => {
        const title = item.querySelector(this.title);

        title.addEventListener("click", (event) => {
          // close all
          if (toggle == true) {
            this.deleteAll();
          }

          // open this
          const el = event.currentTarget;
          const item = el.closest(this.item);
          const content = item.querySelector(this.content);

          if (item.classList.contains("is-active")) {
            item.classList.remove("is-active");
            slideUp(content);
          } else {
            item.classList.add("is-active");
            slideDown(content);
          }
        });
      });
    });
  }
}

new accordion;
