"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var accordion = /*#__PURE__*/function () {
  function accordion() {
    _classCallCheck(this, accordion);

    this.component = ".js-accordion";
    this.item = ".rt-accordion__item";
    this.title = ".rt-accordion__title";
    this.content = ".rt-accordion__content";
    this.toggle = "data-toggle";
    this.open();
  }

  _createClass(accordion, [{
    key: "deleteAll",
    value: function deleteAll() {
      var _this = this;

      var components = querySelectorAll(this.component);
      components.forEach(function (component) {
        var items = component.querySelectorAll(_this.item);
        var titles = component.querySelectorAll(_this.title);
        var contents = component.querySelectorAll(_this.content); //hide all component

        items.forEach(function (element) {
          element.classList.remove("is-active");
        });
        contents.forEach(function (element) {
          element.style.display = "none";
        });
      });
    }
  }, {
    key: "open",
    value: function open() {
      var _this2 = this;

      var components = document.querySelectorAll(this.component);
      components.forEach(function (component) {
        var items = component.querySelectorAll(_this2.item);
        var toggle = component.getAttribute(_this2.toggle);
        items.forEach(function (item) {
          var title = item.querySelector(_this2.title);
          title.addEventListener("click", function (event) {
            // close all
            if (toggle == true) {
              _this2.deleteAll();
            } // open this


            var el = event.currentTarget;
            var item = el.closest(_this2.item);
            var content = item.querySelector(_this2.content);

            if (item.classList.contains("is-active")) {
              item.classList.remove("is-active");
              slideUp(content);
            } else {
              item.classList.add("is-active");
              slideDown(content);
            }
          });
        });
      });
    }
  }]);

  return accordion;
}();

new accordion();
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var comment = /*#__PURE__*/function () {
  function comment() {
    _classCallCheck(this, comment);

    this.comment = ".js-comment";
    this.textarea = "textarea";
    this.input = ".comment-input";
    this.listener();
  }

  _createClass(comment, [{
    key: "listener",
    value: function listener() {
      var _this = this;

      var comments = document.querySelectorAll(this.comment);
      comments.forEach(function (_comment) {
        var textarea = _comment.querySelector(_this.textarea);

        var input = _comment.querySelector(_this.input);

        if (input == null) {
          return false;
        }

        textarea.addEventListener("click", function (event) {
          event.preventDefault();

          if (!_comment.classList.contains("is-active")) {
            _comment.classList.add("is-active");

            slideDown(input);
          }
        });
      });
    }
  }]);

  return comment;
}();

new comment();
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var form = /*#__PURE__*/function () {
  function form() {
    _classCallCheck(this, form);

    this.form = ".js-form-overlay";
    this.input = ".js-form-overlay .rt-form__input";
    this.openAll();
    this.open();
  }
  /**
   * Open/close all form if windows load
   * open if form have value
   * close if form not have value
   */


  _createClass(form, [{
    key: "openAll",
    value: function openAll() {
      var _this = this;

      var inputs = document.querySelectorAll(this.input);
      inputs.forEach(function (input) {
        if (input.value.length > 0) {
          input.closest(_this.form).classList.add("is-active");
        } else {
          input.closest(_this.form).classList.remove("is-active");
        }
      });
    }
    /**
     * Open form on focus
     * run openall function
     */

  }, {
    key: "open",
    value: function open() {
      var _this2 = this;

      var inputs = document.querySelectorAll(this.input);
      inputs.forEach(function (input) {
        input.addEventListener("focus", function (event) {
          var item = event.currentTarget; // close all form

          _this2.openAll(); // active this input


          item.closest(_this2.form).classList.add("is-active");
        });
      });
    }
  }]);

  return form;
}();

new form();
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var menu = /*#__PURE__*/function () {
  function menu() {
    _classCallCheck(this, menu);

    this.menu = ".js-menu";
    this.item = ".rt-menu__item";
    this.submenu = ".rt-menu__submenu";
    this.arrow = ".rt-menu__arrow";
    this.animateIn = "data-animatein";
    this.animateOut = "data-animateOut";
    this.duration = "data-duration";
    this.listener();
  }

  _createClass(menu, [{
    key: "listener",
    value: function listener() {
      var _this = this;

      var menus = document.querySelectorAll(this.menu);
      menus.forEach(function (_menu) {
        var options = {
          items: _menu.querySelectorAll(_this.item),
          arrows: _menu.querySelectorAll(_this.arrow),
          animateIn: _menu.getAttribute(_this.animateIn),
          animateOut: _menu.getAttribute(_this.animateOut),
          duration: _menu.getAttribute(_this.duration)
        };

        if (_menu.classList.contains("rt-menu--vertical")) {
          _this.vertical(options);
        } else {
          _this.horizontal(options);
        }
      });
    }
  }, {
    key: "horizontal",
    value: function horizontal(option) {
      var _this2 = this;

      var items = option.items;
      var animateIn = option.animateIn;
      var animateOut = option.animateOut;
      var duration = option.duration;
      items.forEach(function (item) {
        item.addEventListener("mouseenter", function (event) {
          var el = event.currentTarget;
          var submenu = el.querySelector(_this2.submenu);
          item.classList.add("is-active");

          if (submenu !== null) {
            animateCSS(submenu, option.animateIn, "300");
          }
        });
        item.addEventListener("mouseleave", function (event) {
          var el = event.currentTarget;
          var submenu = el.querySelector(_this2.submenu);
          item.classList.remove("is-active");

          if (submenu !== null) {
            animateCSS(submenu, option.animateOut, "300");
          }
        });
      });
    }
  }, {
    key: "vertical",
    value: function vertical(option) {
      var _this3 = this;

      var items = option.items;
      var animateIn = option.animateIn;
      var animateOut = option.animateOut;
      var duration = option.duration;
      var arrows = option.arrows; // arrow click

      arrows.forEach(function (arrow) {
        arrow.addEventListener("click", function (event) {
          var el = event.currentTarget;
          var item = el.parentNode;
          var submenu = item.querySelector(_this3.submenu);

          if (submenu == null) {
            return false;
          }

          if (item.classList.contains("is-active")) {
            el.classList.remove("is-active");
            item.classList.remove("is-active");
            slideUp(submenu);
          } else {
            el.classList.add("is-active");
            item.classList.add("is-active");
            slideDown(submenu);
          }
        });
      });
    }
  }]);

  return menu;
}();

new menu();
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

/**
 * Retheme Modal Pop up
 * @version 2.0.2
 */
var modal = /*#__PURE__*/function () {
  function modal() {
    _classCallCheck(this, modal);

    this.trigger = ".js-modal";
    this.close = ".js-modal-close";
    this.component = ".rt-modal";
    this.overlay = ".rt-modal__overlay";
    this.inner = ".rt-modal__inner";
    this.animateIn = "data-animatein";
    this.animateOut = "data-animateOut";
    this.scroll = "data-scroll";
    this.listener();
    this["delete"]();
  }

  _createClass(modal, [{
    key: "open",
    value: function open(el) {
      el.element.style.display = "block";
      animateCSS(el.overlay, "fadeIn", "500");
      animateCSS(el.inner, el.animateIn, "500"); // add listener to disable scroll

      document.querySelector("html").style.overflowY = "hidden";
    }
  }, {
    key: "delete",
    value: function _delete(el) {
      var _this2 = this;

      var closes = document.querySelectorAll(this.close);
      closes.forEach(function (close) {
        close.addEventListener("click", function (event) {
          var target = close.closest(_this2.component); // close modal

          animateCSS(target.querySelector(_this2.inner), target.getAttribute(_this2.animateOut), "500");
          animateCSS(target.querySelector(_this2.overlay), "fadeOut", "500").then(function () {
            target.style.display = "none";
          }); // Remove listener to re-enable scroll

          document.querySelector("html").style.overflowY = "auto";
        });
      });
    }
  }, {
    key: "listener",
    value: function listener() {
      var _this3 = this;

      var modals = document.querySelectorAll(this.trigger);
      modals.forEach(function (_modal) {
        var dataTarget = _modal.getAttribute("data-target");

        var target = document.querySelector(dataTarget);

        if (target == null) {
          return false;
        }

        var el = {
          element: target,
          overlay: target.querySelector(_this3.overlay),
          inner: target.querySelector(_this3.inner),
          animateIn: target.getAttribute(_this3.animateIn),
          scroll: target.getAttribute(_this3.scroll)
        };

        _modal.addEventListener("click", function (event) {
          event.preventDefault();
          var _this = event.currentTarget;

          if (_this.classList.contains("disabled")) {
            return false;
          }

          _this3.open(el);
        });
      });
    }
  }, {
    key: "load",
    value: function load(id) {
      var _this4 = this;

      var modals = document.querySelectorAll(id);
      modals.forEach(function (_modal2) {
        var el = {
          element: _modal2,
          overlay: _modal2.querySelector(_this4.overlay),
          inner: _modal2.querySelector(_this4.inner),
          animateIn: _modal2.getAttribute(_this4.animateIn)
        };

        _this4.open(el);
      });
    }
  }]);

  return modal;
}();

new modal();
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

/**
 * Retheme Modal Pop up
 * @version 2.1.0
 */
var slidepanel = /*#__PURE__*/function () {
  function slidepanel() {
    _classCallCheck(this, slidepanel);

    this.trigger = ".js-slidepanel";
    this.component = ".rt-sidepanel";
    this.overlay = ".rt-sidepanel__overlay";
    this.inner = ".rt-sidepanel__inner";
    this.close = ".js-sidepanel-close";
    this.listener();
    this["delete"]();
  }

  _createClass(slidepanel, [{
    key: "open",
    value: function open(el) {
      el.element.style.display = "block";
      el.element.classList.add("is-active");
      animateCSS(el.overlay, "fadeIn", "500");
      animateCSS(el.inner, el.animateIn, "500"); // add listener to disable scroll

      document.querySelector("html").style.overflowY = "hidden";
    }
  }, {
    key: "delete",
    value: function _delete(el) {
      var _this2 = this;

      var closes = document.querySelectorAll(this.close); // close panel

      closes.forEach(function (close) {
        close.addEventListener("click", function (event) {
          var target = close.closest(_this2.component); // panel open from point

          if (target.classList.contains("rt-sidepanel--left")) {
            var flowOut = "slideOutLeft";
          } else if (target.classList.contains("rt-sidepanel--bottom")) {
            var flowOut = "slideOutDown";
          } else if (target.classList.contains("rt-sidepanel--top")) {
            var flowOut = "slideOutUp";
          } else {
            var flowOut = "slideOutRight";
          } // Close panel


          animateCSS(target.querySelector(_this2.inner), flowOut, "500");
          animateCSS(target.querySelector(_this2.overlay), "fadeOut", "500").then(function () {
            target.style.display = "none";
            target.classList.remove("is-active");
          }); // Remove listener to re-enable scroll

          document.querySelector("html").style.overflowY = "auto";
        });
      });
    }
  }, {
    key: "listener",
    value: function listener() {
      var _this3 = this;

      var slidepanels = document.querySelectorAll(this.trigger);
      slidepanels.forEach(function (_slidepanel) {
        var dataTarget = _slidepanel.getAttribute("data-target");

        var target = document.querySelector(dataTarget);

        if (target == null) {
          return false;
        } // panel open from point


        if (target.classList.contains("rt-sidepanel--left")) {
          var flowIn = "slideInLeft";
        } else if (target.classList.contains("rt-sidepanel--bottom")) {
          var flowIn = "slideInUp";
        } else if (target.classList.contains("rt-sidepanel--top")) {
          var flowIn = "slideInDown";
        } else {
          var flowIn = "slideInRight";
        }

        var el = {
          element: target,
          overlay: target.querySelector(_this3.overlay),
          inner: target.querySelector(_this3.inner),
          animateIn: flowIn
        }; // open

        _slidepanel.addEventListener("click", function (event) {
          event.preventDefault();
          var _this = event.currentTarget;

          if (_this.classList.contains("disabled")) {
            return false;
          } // Run open action


          _this3.open(el);
        });
      });
    }
    /**
     * open automatic if windows load
     * @param {id component panel} id
     */

  }, {
    key: "load",
    value: function load(id) {
      var _this4 = this;

      var slidepanels = document.querySelectorAll(id);
      slidepanels.forEach(function (_slidepanel2) {
        // flow panel animation
        // panel open from point
        if (_slidepanel2.classList.contains("rt-sidepanel--left")) {
          var flowIn = "slideInLeft";
        } else if (_slidepanel2.classList.contains("rt-sidepanel--bottom")) {
          var flowIn = "slideInUp";
        } else if (_slidepanel2.classList.contains("rt-sidepanel--top")) {
          var flowIn = "slideInDown";
        } else {
          var flowIn = "slideInRight";
        }

        var el = {
          element: _slidepanel2,
          overlay: _slidepanel2.querySelector(_this4.overlay),
          inner: _slidepanel2.querySelector(_this4.inner),
          animateIn: flowIn
        };

        _this4.open(el);
      });
    }
  }]);

  return slidepanel;
}();

new slidepanel();
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var tabs = /*#__PURE__*/function () {
  function tabs() {
    _classCallCheck(this, tabs);

    this.tab = '.js-tab';
    this.item = '.rt-tab__item';
    this.title = ".rt-tab__title";
    this.open();
  }

  _createClass(tabs, [{
    key: "hideAll",
    value: function hideAll(_tabs) {
      _tabs.title.forEach(function (element) {
        element.classList.remove("is-active");
      });

      _tabs.item.forEach(function (element) {
        element.classList.remove("is-active");
        element.style.display = "none";
      });
    }
  }, {
    key: "open",
    value: function open() {
      var _this = this;

      var _tabs2 = document.querySelectorAll(this.tab);

      _tabs2.forEach(function (tab) {
        // get all element
        var items = tab.querySelectorAll(_this.item);
        var titles = tab.querySelectorAll(_this.title);
        titles.forEach(function (title) {
          title.addEventListener("click", function (event) {
            event.preventDefault();
            var el = event.currentTarget;
            var dataItem = el.getAttribute("href");
            var item = tab.querySelector(dataItem); // hide all tabs

            _this.hideAll({
              title: titles,
              item: items
            }); // show this tabs


            el.classList.add("is-active");
            item.classList.add("is-active");
            item.style.display = "block";
          });
        });
      });
    }
  }]);

  return tabs;
}();

new tabs();
"use strict";

// add class if js ready
document.querySelector("html").classList.remove("no-js");
document.querySelector("html").classList.add("js");
/* =================================================
 *  STICKY HEADER
 * =================================================== */

function headerFloatDesktop() {
  var header = document.querySelector(".js-header");

  if (header == null) {
    return false;
  }

  var sticky = header.getAttribute("data-sticky");
  var headerHeight = header.clientHeight;

  if (window.pageYOffset > headerHeight && sticky == true) {
    header.classList.add("is-sticky");
  } else {
    header.classList.remove("is-sticky");
  }
}

window.addEventListener("scroll", headerFloatDesktop); // header sm sticky

function headerFloatMobile() {
  var header = document.querySelector(".js-header-mobile");

  if (header == null) {
    return false;
  }

  var sticky = header.getAttribute("data-sticky");
  var headerHeight = header.clientHeight;

  if (window.pageYOffset > headerHeight && sticky == true) {
    header.classList.add("is-sticky");
  } else {
    header.classList.remove("is-sticky");
  }
}

window.addEventListener("scroll", headerFloatMobile);
/*=================================================;
/* BACK HISTORY
/*================================================= */

function windowBack() {
  var triggers = document.querySelectorAll(".js-window-back");
  triggers.forEach(function (trigger) {
    trigger.addEventListener("click", function (event) {
      event.preventDefault();
      window.history.back();
    });
  });
}

windowBack();
/* =================================================
 *  GOTOP
 * =================================================== */

function gotop() {
  var gotop = document.querySelector(".js-gotop");

  if (gotop == null) {
    return false;
  } // show gotop button


  if (window.pageYOffset > 200) {
    gotop.style.display = "block";
  } else {
    gotop.style.display = "none";
  } // scroll to top


  gotop.addEventListener("click", function () {
    window.scrollTo({
      top: 0,
      behavior: "smooth"
    });
  });
}

window.addEventListener("scroll", gotop);