<?php

namespace Webforia_Whatsapp;

class Setup
{

    public function __construct()
    {
        // scripts
        add_action('wp_enqueue_scripts', [$this, 'scripts']);

        load_plugin_textdomain('webforia-whatsapp-chat', false, dirname(plugin_basename(__FILE__)) . '/languages/');

    }

    public function scripts()
    {

        // deactive this if theme by retheme framework ready
        if (wwc_option('retheme_setup') == false) {
            // Animate
            wp_enqueue_script('animate', WEBFORIA_WHATSAPP_CHAT_ASSETS . 'assets/js/animate.min.js', false, '1.4.0', true);
            wp_enqueue_style('animate', WEBFORIA_WHATSAPP_CHAT_ASSETS . 'assets/css/animate.min.css', false, '2.0.1', false);
            wp_enqueue_script('retheme-form', WEBFORIA_WHATSAPP_CHAT_ASSETS . 'assets/js/main/_form.min.js', array('animate'), '2.0.0', true);
            wp_enqueue_script('retheme-modal', WEBFORIA_WHATSAPP_CHAT_ASSETS . 'assets/js/main/_modal.min.js', array('animate'), '2.0.0', true);
            wp_enqueue_style('retheme-base', WEBFORIA_WHATSAPP_CHAT_ASSETS . 'assets/css/retheme-base.min.css', false, '2.0.2', false);
            // Main WhatsApp Chat
            wp_enqueue_script('retheme-variation', WEBFORIA_WHATSAPP_CHAT_ASSETS . 'assets/js/woocommerce/variation.min.js', array('jquery'), '3.0.1', true);
            wp_enqueue_script('retheme-helper', WEBFORIA_WHATSAPP_CHAT_ASSETS . 'assets/js/helper.min.js', false, '1.0.0', true);
        }

        wp_enqueue_style('webforia-whatsapp-chat-theme-support', WEBFORIA_WHATSAPP_CHAT_ASSETS . 'assets/css/theme-support.min.css', false, '1.0.0', false);
        wp_enqueue_script('webforia-whatsapp-chat', WEBFORIA_WHATSAPP_CHAT_ASSETS . 'assets/js/whatsapp-chat.min.js', array('jquery', 'animate'), '4.0.0', true);
        wp_enqueue_style('webforia-whatsapp-chat', WEBFORIA_WHATSAPP_CHAT_ASSETS . 'assets/css/whatsapp-chat.min.css', false, '4.0.0', false);
    }

}
