<?php
namespace Webforia_Whatsapp;

class Whatsapp
{
    public function __construct()
    {
        // add whatsapp button
        add_action('wp_footer', [$this, 'chat_widgets_render']);
        add_shortcode('webforia-whatsapp-chat', [$this, 'chat_widgets_render']);
        add_filter('body_class', [$this, 'add_body_class']);

        // WBS v1 support
        add_action('wsb_after_add_to_cart_button', [$this, 'checkout_button_render']);

        // conditional move whatsapp location if catalog product active
        if (wwc_option('woocommerce_catalog', false)) {
            add_action('woocommerce_single_product_summary', [$this, 'checkout_button_render'], 30);
        } else {
            add_action('woocommerce_after_add_to_cart_button', [$this, 'checkout_button_render']);
        }

        // modal
        add_action('wp_footer', [$this, 'checkout_form_order_render']);

    }

    /**
     * Add class chat on body
     *
     * @param [type] $classes
     * @return void
     */
    public function add_body_class($classes)
    {
        $classes[] = (wwc_option('whatsapp_chat_widget', true)) ? 'whatsapp-chat' : '';
        $classes[] = (wwc_option('whatsapp_product_action', 'modal') != 'none') ? 'whatsapp-checkout' : '';

        return $classes;
    }

    /**
     * Add WhatsApp chat
     *
     * @hook action wp_footer
     */
    public function chat_widgets_render()
    {

        if (wwc_option('whatsapp_chat_widget', true) && wwc_get_activation()) {
            wwc_get_template_part('whatsapp-chat');
        }

    }

    /**
     * Chat action trigger
     *
     * Add buton on sticky product page action button retheme framework
     * @hook action rt_before_sticky_action
     * @return void
     */
    public function chat_widgets_action()
    {
        wwc_chat_trigger();
    }

    /**
     * Add button redirect to whatsapp beside add to cart button on product page
     *
     * @hook action rt_after_sticky_action
     * @hook action woocommerce_single_product_summary
     * @return void
     */
    public function checkout_button_render()
    {
       wwc_product_checkout();
    }

    /**
     * Add modal checkout
     *
     * @hook action wp_footer
     * @return void
     */
    public function checkout_form_order_render()
    {

        if (wwc_option('whatsapp_product_action', 'modal') == 'modal' && wwc_get_activation()) {

            wwc_get_template_part('order-form-modal');

        }

    }

}
