<?php
/**
 * Rotator whatsapp number ajax
 * 1.0.1
 */
namespace Webforia_Whatsapp;

class Rotator
{
    public function __construct()
    {
        add_action('init', [$this, 'set_number']);
    }

    /**
     * Set number form rotator settings
     *
     * @return void
     */
    public function set_number()
    {
        $number = wwc_option('whatsapp_number', 'option');

        if (is_array($number)) {
            $count_number  = count($number) - 1;
            $queque_number = get_option('whatsapp_rotator_queque', 0);

            // get whatsapp number from array
            if (!empty($number)) {
                $queque_current = $number[$queque_number]['number'];
            } else {
                $queque_current = '6208511111111';
            }

            if (empty(get_option('whatsapp_rotator_queque'))) {
                add_option('whatsapp_rotator_queque', 0);
            }

            // fill option
            update_option('whatsapp_rotator_current', $queque_current);

            if ($queque_number < $count_number) {
                update_option('whatsapp_rotator_queque', $queque_number + 1);
            } else {
                update_option('whatsapp_rotator_queque', 0);
            }
            // set cookies
            setcookie('whatsapp_rotator_currents', $queque_current, time() + (86400 * 7), "/");
        }
    }

    /**
     * Get number form options db
     *
     * @return void
     */
    public function get_number()
    {
        if (wwc_option('whatsapp_number_cookies') && !empty($_COOKIE['whatsapp_rotator_currents'])) {
            $number = $_COOKIE['whatsapp_rotator_currents'];
        } else {
            $number = get_option('whatsapp_rotator_current');
        }

        return apply_filters('whatsapp_current_number', $number);
    }

}
