<?php

namespace Webforia_Whatsapp;

use Carbon_Fields\Container;
use Carbon_Fields\Field;

class Options
{
    public function __construct()
    {
        add_action('carbon_fields_register_fields', [$this, 'options']);
    }

    public function options()
    {
        $menu = (class_exists('woocommerce')) ? 'woocommerce' : 'options-general.php';

        Container::make('theme_options', __('WhatsApp'))
            ->set_page_parent($menu)
            ->set_classes('cf-tabs-horizontal')
            ->add_tab('General', $this->general())
            ->add_tab(__('Chats'), $this->chat())
            ->add_tab(__('Product'), $this->product())
            ->add_tab(__('Checkout'), $this->checkout())
            ->add_tab(__('Follow Up'), $this->followUp());
    }

    public function general()
    {
        return array(
            Field::make('complex', 'whatsapp_number', __('Nomor WhatsApp'))
                ->setup_labels(array(
                    'plural_name' => 'Customer Service',
                    'singular_name' => 'Customer Service',
                ))
                ->add_fields(array(
                    Field::make('text', 'name', __('Nama'))->set_required(true),
                    Field::make('text', 'number', __('Nomor WhatsApp'))->set_required(true),
                ))
                ->set_header_template('
                <% if (name) { %>
                    <%- name %>
                <% } %>
            ')
                ->set_collapsed(true)
                ->set_min(1),
        );
    }

    public function chat()
    {
        return array(
            Field::make('checkbox', 'whatsapp_chat_widget', __('Widget WhatsApp Chat'))
                ->set_option_value('yes')
                ->set_default_value(true),
            Field::make('checkbox', 'whatsapp_chat_autoload', __('Widget Autoload'))
                ->set_option_value('yes')
                ->set_conditional_logic(array(
                    array(
                        'field' => 'whatsapp_chat_widget',
                        'value' => true,
                        'compare' => '=',
                    ),
                )),
            Field::make('text', 'whatsapp_chat_cs_name', __('Nama Toko'))
                ->set_default_value('Nama Toko')
                ->set_help_text('Silakan masukan nama toko Anda')
                ->set_required(true),
            Field::make('image', 'whatsapp_chat_avatar', __('Gambar/Logo')),
            Field::make('textarea', 'whatsapp_chat_welcome_text', __('Deskripsi'))
                ->set_default_value('Selamat datang di Toko Kami. Kami siap membantu semua kebutuhan Anda')
                ->set_help_text('<strong>Contoh:</strong> Selamat datang di Toko Kami. Kami siap membantu semua kebutuhan Anda'),
            Field::make('text', 'whatsapp_chat_placeholder', __('Intruksi'))
                ->set_default_value('Tulis pesan disini kemudian tekan enter')
                ->set_help_text('<strong>Contoh:</strong> Tulis pesan disini kemudian tekan enter'),
            Field::make('textarea', 'whatsapp_chat_message', __('Pesan Pembuka'))
                ->set_default_value('Selamat datang, ada yang bisa Saya bantu')
                ->set_help_text('<strong>Contoh:</strong> Selamat datang, ada yang bisa Saya bantu'),
            Field::make('select', 'whatsapp_chat_pixel_event', __('Facebook Pixel'))->set_options(array(
                'none' => 'None',
                'Contact' => 'Contact',
                'Lead' => 'Lead',
                'AddToCart' => 'Add To Cart',
                'AddPaymentInfo' => 'Add Payment Info',
                'InitiateCheckout' => 'Initiate Checkout',
                'Purchase' => 'Purchase',
            ))
                ->set_default_value('Contact'),

        );
    }

    public function product()
    {
        return array(
            Field::make('radio', 'whatsapp_product_action', __('Checkout Type'))
                ->set_options(
                    array(
                        'none' => 'Disable WhatsApp Button',
                        'redirect' => 'Redirect to WhatsApp',
                        'modal' => 'Form Order'
                    )
                )
                ->set_default_value('redirect')
                ->set_help_text('Pilih aksi yang diterapkan pada button checkout whatsapp dihalaman single produk'),

            Field::make('text', 'whatsapp_product_text', __('Teks Pada Tombol'))
                ->set_default_value('Beli Lewat WhatsApp')
                ->set_help_text('<strong>Contoh:</strong> Beli Lewat WhatsApp')
                ->set_required(true),

            Field::make('text', 'whatsapp_product_modal_title', __('Judul Fomulir'))
                ->set_default_value('WhatsApp Form')
                ->set_help_text('Masukan judul kolom pemesanan <br><strong>Contoh: </strong>Lakukan pemesanan lewat WhatsApp')
                ->set_conditional_logic(array(
                    array(
                        'field' => 'whatsapp_product_action',
                        'value' => 'modal',
                        'compare' => '=',
                    ),
                )),
            Field::make('textarea', 'whatsapp_product_desc', __('Intruksi Pemesanan'))
                ->set_help_text('<strong>Contoh: </strong>Silakan isi kolom dibawah ini untuk melakukan pemesanan produk')
                ->set_conditional_logic(array(
                    array(
                        'field' => 'whatsapp_product_action',
                        'value' => 'modal',
                        'compare' => '=',
                    ),
                )),
            Field::make('textarea', 'whatsapp_product_message', __('Isi Pesan'))
                ->set_help_text('Anda bisa menggunakan text map untuk menampilkan attribute order pada pesan yang dikirim<br><strong>Text Map untuk button redirect:</strong>{{product}} {{quantity}} {{total}} {{link}} <br><strong>Text Map untuk form order:</strong> {{order_number}} {{order_date}} {{order_detail}} {{first_name}} {{last_name}} {{billing}} {{shipping}} {{bank}} {{note}} <br> <strong>Contoh: </strong> <br>Hai admin saya telah melakukan pembelian, berikut detail pesanan saya <br> Detail pesanan: {{order_detail}} <br> Alamat Tagihan: {{billing}} <br> Alamat Pengiriman: {{shipping}} <br>'),
            Field::make('set', 'whatsapp_product_field', __('Fomulir Order'))
                ->add_options(array(
                    'fullname' => 'Nama lengkap',
                    'email' => 'Email',
                    'phone' => 'Nomor Telephone/WhatsApp',
                    'address' => 'Alamat Lengkap',
                    'note' => 'Catatan tambahan',
                ))
                ->set_help_text('Silakan pilih kolom yang ingin ditampilkan pada fitur pemesanan')
                ->set_conditional_logic(array(
                    array(
                        'field' => 'whatsapp_product_action',
                        'compare' => '=',
                        'value' => 'modal',
                    ),
                )),
            Field::make('select', 'whatsapp_product_pixel_event', __('Facebook Pixel'))
                ->set_options(array(
                    'none' => 'None',
                    'Contact' => 'Contact',
                    'Lead' => 'Lead',
                    'AddToCart' => 'Add To Cart',
                    'AddPaymentInfo' => 'Add Payment Info',
                    'InitiateCheckout' => 'Initiate Checkout',
                    'Purchase' => 'Purchase',
                )),
        );
    }

    public function checkout()
    {
        return array(
            Field::make('radio', 'whatsapp_checkout_action', __('Checkout Action'))
                ->set_options(array(
                    'disable' => 'Disable',
                    'redirect' => 'Otomatis redirect saat checkout',
                    'thank_button' => 'Tombol konfirmasi dihalaman thank page',
                    'replace_button' => 'Ganti tombol checkout',
                ))
                ->set_default_value('thank_button'),

            Field::make('text', 'whatsapp_checkout_button', __('Teks Pada Tombol'))
                ->set_default_value('Beli lewat whatsapp')
                ->set_help_text('Masukkan teks pada tombol WhatsApp <br><strong>Contoh:</strong> Kirim Detail Pesanan'),

            Field::make('text', 'whatsapp_checkout_confirmation_heading', __('Sambutan'))
                ->set_default_value('Terima kasih telah melakukan pesanan di toko kami')
                ->set_conditional_logic(array(
                    array(
                        'field' => 'whatsapp_checkout_action',
                        'value' => 'thank_button',
                        'compare' => '=',
                    ),
                ))
                ->set_help_text('Anda dapat mempersonalisasi judul dengan mengubahnya dengan domain<br> <strong>Text Map</strong> {{fullname}} <br> <strong>Contoh: </strong>Terima kasih telah melakukan pesanan di toko kami'),

            Field::make('textarea', 'whatsapp_checkout_confirmation_intruction', __('Intruksi'))
                ->set_default_value('Untuk respons yang lebih cepat, kirim detail pesanan Anda dengan mengklik tombol di bawah ini. ')
                ->set_conditional_logic(array(
                    array(
                        'field' => 'whatsapp_checkout_action',
                        'value' => 'thank_button',
                        'compare' => '=',
                    ),
                ))
                ->set_help_text('Tulis intruksi pada pelanggan untuk klik tombol whatsapp<br> <strong>Contoh: </strong> Untuk respons yang lebih cepat, kirim detail pesanan Anda dengan mengklik tombol di bawah ini.'),

            Field::make('textarea', 'whatsapp_checkout_message', __('Isi Pesan'))
                ->set_help_text('Anda bisa menggunakan text map untuk menampilkan attribute order pada pesan yang dikirim<br><strong>Text Map:</strong> {{order_number}} {{order_date}} {{order_detail}} {{first_name}} {{last_name}} {{billing}} {{shipping}} {{bank}} {{note}} <br> <strong>Contoh: </strong> <br>Hai admin saya telah melakukan pembelian, berikut detail pesanan saya <br> Detail pesanan: {{order_detail}} <br> Alamat Tagihan: {{billing}} <br> Alamat Pengiriman: {{shipping}} <br>'),
        );
    }

    public function followUp()
    {
        return array(

            Field::make('html', 'whatsapp_follow_up_heading_info')
                ->set_html('')
                ->set_help_text('Anda bisa menggunakan text map untuk menampilkan attribute order pada pesan yang dikirim<br><strong>Text Map:</strong> {{order_number}} {{order_date}} {{order_detail}} {{first_name}} {{last_name}} {{billing}} {{shipping}} {{bank}} {{note}}'),

            Field::make('textarea', 'whatsapp_follow_up_onhold', __('Pesanan Belum Dibayar'))
                ->set_help_text('Text template yang dikirimkan saat pesanan belum dibayar <br> <strong>Contoh:</strong>Hai {{first_name}} {{last_name}} <br> Cuma mengingatkan, orderan Anda dengan nomor pemesanan {{order_number}} belum selesai.<br> Detail pesanan:{{order_detail}}<br> Alamat Tagihan:{{billing}}<br> Alamat Pengiriman:{{shipping}}<br>'),
        );
    }

    public function style()
    {
        return array(
            Field::make( 'color', 'wwc_button_color', 'Color' )
                ->set_alpha_enabled( true )
                ->set_default_value('#ffffff'),
            Field::make( 'color', 'wwc_button_color_accent', 'Accent Color' )
                ->set_alpha_enabled( true )
                ->set_default_value('#ffffff'),
            Field::make( 'color', 'wwc_button_background', 'Background' )
                ->set_alpha_enabled( true )
                ->set_default_value('#25d366'),
            Field::make( 'color', 'wwc_button_background_accent', 'Accent Background' )
                ->set_alpha_enabled( true )
                ->set_default_value('#4be083'),
            Field::make( 'color', 'wwc_button_border_color', 'Border Color' )
                ->set_alpha_enabled( true )
                ->set_default_value('#25d366'),
            Field::make( 'color', 'wwc_button_border_color_accent', 'Accent Border Color' )
                ->set_alpha_enabled( true )
                ->set_default_value('#4be083'),
        );
    }
}
