<?php
namespace Webforia_Whatsapp;

use Webforia\Customizer_Base;

class Customizer extends Customizer_Base
{

    public function __construct()
    {
        \Kirki::add_config('whatsapp_chat_customizer', array(
            'capability' => 'edit_theme_options',
            'option_type' => 'option',
        ));

        add_action('init', [$this, 'add_button_whatsapp']);
    }

    /**
     * Add field control
     */
    public function add_field($args)
    {
        \Kirki::add_field('whatsapp_chat_customizer', $args);
    }

    public function add_button_whatsapp()
    {
        $section = "whatsapp_chat_section";

        $this->add_section('', array(
            'whatsapp_chat' => array(esc_attr__('WhatsApp Chat', WEBFORIA_WHATSAPP_CHAT_DOMAIN)),
            'priority' => 999,
        ));

        $this->add_field_color(array(
            'settings' => 'button_whatsapp_color',
            'section' => $section,
            'default' => [
                'normal' => '#fff',
                'hover' => '#fff',
            ],
            'element' => '.button.rt-btn.rt-btn--whatsapp',
            'output' => array(
                array(
                    'element' => '.button.rt-btn.rt-btn--whatsapp',
                    'property' => 'color',
                    'suffix' => '!important',
                    'choice' => 'normal',
                ),
                array(
                    'element' => '.button.rt-btn.rt-btn--whatsapp:before',
                    'property' => 'background',
                    'suffix' => '!important',
                    'choice' => 'normal',
                ),
                array(
                    'element' => '.button.rt-btn.rt-btn--whatsapp:hover, 
                                    .button.rt-btn.rt-btn--whatsapp:focus',
                    'suffix' => '!important',
                    'property' => 'color',
                    'choice' => 'hover',
                ),
                array(
                    'element' => '.button.rt-btn.rt-btn--whatsapp:hover::before, 
                                    .button.rt-btn.rt-btn--whatsapp:focus::before',
                    'property' => 'background',
                    'suffix' => '!important',
                    'choice' => 'hover',
                ),

            ),
            'pseudo' => 'all',

        ));

        $this->add_field_background(array(
            'settings' => 'button_whatsapp_background',
            'section' => $section,
            'default' => [
                'normal' => '#25D366',
                'hover' => '#4be083',
            ],
            'element' => '.button.rt-btn.rt-btn--whatsapp',
            'pseudo' => 'all',
            'suffix' => '!important',
        ));

        $this->add_field_border_color(array(
            'settings' => 'button_whatsapp_border_color',
            'section' => $section,
            'default' => [
                'normal' => '#25D366',
                'hover' => '#4be083',
            ],
            'element' => '.button.rt-btn.rt-btn--whatsapp',
            'pseudo' => 'all',
            'suffix' => '!important',
        ));

    }
}
