<?php
/**
 * Chekout handle
 * @version 1.0.1
 */
namespace Webforia_Whatsapp;

class Checkout
{
    public function __construct()
    {
        add_action('woocommerce_before_thankyou', [$this, 'checkout_message'], 1);
        add_filter('woocommerce_order_button_html', [$this, 'button_checkout']);
    }

    /**
     * Add button on checkout page
     *
     * @param [type] $button_html
     * @return void
     */
    public function button_checkout($button_html)
    {
        $order_button_text = wwc_option('whatsapp_checkout_button', 'Beli via WhatsApp');

        // replace default checkout button
        if (wwc_option('whatsapp_checkout_action') === 'replace_button' && wwc_get_activation()) {
            $button_html = '<button type="submit" class="button rt-btn rt-btn--whatsapp rt-btn--block rt-place-order-whatsapp" name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr($order_button_text) . '" data-value="' . esc_attr($order_button_text) . '">';
            $button_html .= $order_button_text;
            $button_html .= '</button>';
        }

        return $button_html;

    }


    /**
     * Redirect WhatsApp on thank page
     * Added button redirect on thank page
     *
     * @param [type] $order_id
     * @return void
     */
    public function checkout_message($order_id)
    {
        $order_class = New Order;
        $order = wc_get_order($order_id);
        $fullname = wp_sprintf('%s %s', $order->get_billing_first_name(), $order->get_billing_last_name());
        $action = wwc_option('whatsapp_checkout_action', 'thank_button');

        $data['name'] = $fullname;
        $data['link'] = $order_class->create_whatsapp_link($order_id, wwc_option('whatsapp_checkout_message'));
        $data['button'] = wwc_option('whatsapp_checkout_button', 'Beli via WhatsApp');;
        $data['heading'] = str_replace('{{fullname}}', $fullname, wwc_option('whatsapp_checkout_confirmation_heading', 'Terima kasih telah melakukan pesanan di toko kami'));
        $data['intruction'] = wwc_option('whatsapp_checkout_confirmation_intruction', 'Untuk respons yang lebih cepat, kirim detail pesanan Anda dengan mengklik tombol di bawah ini.');

        if ($action == 'thank_button') {
            wwc_get_template_part('checkout-message', $data);
        } else if (in_array($action, array('redirect', 'replace_button'))) {
            echo '<script>window.location.href = "' . $data['link'] . '";</script>';
        }

    }
    

}