<?php
/*=================================================;
/* GET TEMPLATE
/*================================================= */
function wwc_get_template_part($template, $data = '')
{
    $loader = new Webforia_Whatsapp\Template;

    $loader->set_template_data($data)
        ->get_template_part("template-parts/{$template}");

}

/*=================================================;
/* OPTIONS
/*================================================= */
function wwc_option($option, $default = '')
{
    if (get_post_meta(get_the_ID(), $option, true)) {

        $get_option = get_post_meta(get_the_ID(), $option, true);

    } else if (function_exists('carbon_get_theme_option') && $default == 'option') {
        $get_option = carbon_get_theme_option($option);
    } else {
        $get_option = get_option("_{$option}", $default);
    }

    return apply_filters($option, $get_option);
}

/*=================================================;
/* PLUGIN STATUS
/*================================================= */
function wwc_get_activation()
{
    $option = get_option('webforia-wa-chat_status');
    $status = ($option == 'active' || $option == 'extended') ? true : false;
    return apply_filters('webforia_wa_chat', $status);
}

/*=================================================;
/* THEME SUPPORT
/*================================================= */
function wwc_retheme_setup(){
    add_filter( 'webforia_wa_chat', '__return_true');
}
add_action( 'rt_after_setup_theme', 'wwc_retheme_setup');

/*=================================================;
/* FORMAT TEXTAREA TO WHATSAPP
/*================================================= 
* @return whatsapp message format
* @version 1.0.0
*/
function wwc_whatsapp_text_format($text)
{
    $string = preg_replace("/[\n\r]/", '<br>', $text);
    $map = array('<br><br>', '<br>', '<br/>', ' ', '<strong>', '</strong>', '&');
    $format = array('%0A', '%0A', '%0A', '%20', '*', '*', '%26');

    return str_replace($map, $format, $string);
}

function wwc_br2newline($text)
{
    return preg_replace('/\<br(\s*)?\/?\>/i', "\n", $text);
}

/*=================================================;
/* PRICE FORMAT WITHOUT MARKUP HTML
/*================================================= */
function wwc_price($price)
{
    return strip_tags(wc_price($price));
}

/*=================================================;
/* PHONE FORMAT COUNTRY
/*================================================= */
function wwc_phone_format($phone)
{
    return preg_replace('/^0/', '62', $phone);
}

/*=================================================;
/* GET FIRST NAME AND LAST NAME
/*================================================= */
function wwc_split_fullname($name)
{
    // text to array
    $fullname = explode(' ', $name);

    // Get first name
    $name_new['first_name'] = !empty($fullname[0]) ? $fullname[0] : '';

    // Get last name
    array_shift($fullname);
    $name_new['last_name'] = implode(" ", $fullname);
    
    return $name_new;
}

/*=================================================;
/* GET CURRENT NUMBER
/*================================================= */
function wwc_rotator_number()
{
    $rotator = new Webforia_Whatsapp\Rotator;
    return $rotator->get_number();
}

