<?php
namespace OrderTalk;

use Elementor;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

/**
 * Main Plugin Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */

class WWC_Elementor
{

    /**
     * Constructor
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function __construct()
    {
        add_action('elementor/widgets/widgets_registered', [$this, 'on_widgets_registered']);
        add_action('elementor/init', array($this, 'register_category'));
        // add_action('wp_enqueue_scripts', [$this, 'register_frontend_scripts']);
    }

    /**
     * On Widgets Registered
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function on_widgets_registered()
    {
        $this->register_widget();
    }

    public function register_category()
    {
        Elementor\Plugin::instance()->elements_manager->add_category(
            'wwc-elements',
            [
                'title' => 'WhatsApp Chat',
                'icon' => 'font',
            ],
            1
        );
    }


    public function register_frontend_scripts()
    {
        wp_enqueue_script('wwc-elementor', get_template_directory_uri() . '/elementor/assets/js/wwc-elementor.min.js', '', '1.0.0', true);
    }


    /**
     * Register Widget
     *
     * @since 1.0.0
     *
     * @access private
     */
    private function register_widget()
    {   
        require __DIR__ . '/button/button.php';
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \Webforia_Whatsapp\Elementor\Button());
    }

    // end class
}

new WWC_Elementor();
