<?php
namespace Webforia_Whatsapp\Elementor;

use \Elementor\Controls_Manager;
use \Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use \Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Button extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'wwc-button';
    }

    public function get_title()
    {
        return __('WhatsApp Button', WEBFORIA_WHATSAPP_CHAT_DOMAIN);
    }

    public function get_icon()
    {
        return 'eicon-button';
    }

    public function get_categories()
    {
        return ['wwc-elements'];
    }

    protected function _register_controls()
    {
        $this->button();
        $this->whatsapp();
        $this->style();
    }

    public function button()
    {
        $this->start_controls_section(
            'setting_button',
            [
                'label' => __('Button', WEBFORIA_WHATSAPP_CHAT_DOMAIN),
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => esc_html__('Text', 'elementor'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => esc_html__('Click here', 'elementor'),
                'placeholder' => esc_html__('Click here', 'elementor'),
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'label' => esc_html__('Icon', 'elementor'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__('Alignment', 'elementor'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justified', 'elementor'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'default' => '',
            ]
        );

        $this->end_controls_section();
    }

    public function whatsapp()
    {
        $this->start_controls_section(
            'setting_whatsapp',
            [
                'label' => __('WhatsApp', WEBFORIA_WHATSAPP_CHAT_DOMAIN),
            ]
        );

        $this->add_control(
            'custom_number',
            [
                'label' => esc_html__('Custom Number', 'elementor'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => __('Number', WEBFORIA_WHATSAPP_CHAT_DOMAIN),
                'type' => Controls_Manager::TEXT,
                'default' => __('62000', WEBFORIA_WHATSAPP_CHAT_DOMAIN),
                'condition' => [
                    'custom_number' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'message',
            [
                'label' => __('Message', WEBFORIA_WHATSAPP_CHAT_DOMAIN),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Message', WEBFORIA_WHATSAPP_CHAT_DOMAIN),
            ]
        );

        $this->add_control(
            'facebook_pixel',
            [
                'label' => esc_html__('Facebook Pixel', WEBFORIA_WHATSAPP_CHAT_DOMAIN),
                'type' => Controls_Manager::SELECT,
                'default' => 'Contact',
                'options' => [
                    'none' => 'None',
                    'Contact' => 'Contact',
                    'Lead' => 'Lead',
                    'AddToCart' => 'Add To Cart',
                    'AddPaymentInfo' => 'Add Payment Info',
                    'InitiateCheckout' => 'Initiate Checkout',
                    'Purchase' => 'Purchase',
                ],
            ]
        );

        $this->end_controls_section();
    }

    public function style()
    {
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Button', 'elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_ACCENT,
                ],
                'selector' => '{{WRAPPER}} .elementor-button',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'text_shadow',
                'selector' => '{{WRAPPER}} .elementor-button',
            ]
        );

        $this->start_controls_tabs('tabs_button_style');

        $this->start_controls_tab(
            'tab_button_normal',
            [
                'label' => esc_html__('Normal', 'elementor'),
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('Text Color', 'elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-button' => 'fill: {{VALUE}}; color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__('Background', 'elementor'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .elementor-button',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic',
                    ],
                    'color' => [
                        'global' => [
                            'default' => Global_Colors::COLOR_ACCENT,
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_button_hover',
            [
                'label' => esc_html__('Hover', 'elementor'),
            ]
        );

        $this->add_control(
            'hover_color',
            [
                'label' => esc_html__('Text Color', 'elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-button:hover, {{WRAPPER}} .elementor-button:focus' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-button:hover svg, {{WRAPPER}} .elementor-button:focus svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button_background_hover',
                'label' => esc_html__('Background', 'elementor'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .elementor-button:hover, {{WRAPPER}} .elementor-button:focus',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic',
                    ],
                ],
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'elementor'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-button:hover, {{WRAPPER}} .elementor-button:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__('Hover Animation', 'elementor'),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .elementor-button',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('Border Radius', 'elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .elementor-button',
            ]
        );

        $this->add_responsive_control(
            'text_padding',
            [
                'label' => esc_html__('Padding', 'elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        // Get ID
        $widget_id = $this->get_id();

        // Get settings
        $settings = $this->get_settings_for_display();

        // Get number from rotator
        if($settings['custom_number'] == 'yes' && !empty($settings['number'])){
            $number = $settings['number'];
        }else{
            $number = wwc_rotator_number();
        }
        $message = wwc_whatsapp_text_format($settings['message']);

        $link = "https://api.whatsapp.com/send?phone={$number}&text={$message}";

        $this->add_render_attribute('wrapper', 'class', 'elementor-button-wrapper');

        $this->add_render_attribute('button', 'href', $link);
        $this->add_render_attribute('button', 'class', 'elementor-button-link wwc-whatsapp-button');

        $this->add_render_attribute('button', 'class', 'elementor-button');
        $this->add_render_attribute('button', 'role', 'button');

        $this->add_render_attribute('button', 'id',  "wwc_button_{$widget_id}");

        if (!empty($settings['size'])) {
            $this->add_render_attribute('button', 'class', 'elementor-size-' . $settings['size']);
        }

        if ($settings['hover_animation']) {
            $this->add_render_attribute('button', 'class', 'elementor-animation-' . $settings['hover_animation']);
        }

        $this->add_render_attribute([
            'content-wrapper' => [
                'class' => 'elementor-button-content-wrapper',
            ],
            'text' => [
                'class' => 'elementor-button-text',
            ],
        ]);

        $this->add_inline_editing_attributes('text', 'none');
        ?>
		<div <?php $this->print_render_attribute_string('wrapper');?>>
			<a <?php $this->print_render_attribute_string('button');?>>
                <span <?php $this->print_render_attribute_string('content-wrapper');?>>
                    <?php if ($settings['button_icon'] == 'yes'): ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" fill="currentColor" class="bi bi-whatsapp" viewBox="0 0 16 16" style="position: relative; margin-right: 10px; margin-bottom: -1px;">
                        <path d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z"></path>
                    </svg>
                    <?php endif?>
                    <span <?php $this->print_render_attribute_string('text');?>><?php $this->print_unescaped_setting('text');?></span>
                </span>
			</a>
		</div>
        <style>.wwc-whatsapp-button{background: #25d366;}.wwc-whatsapp-button:hover{background: #4be083;}</style>
        <?php if(!empty($settings['facebook_pixel']) && $settings['facebook_pixel'] != 'none'): ?>
            <?php if ( !\Elementor\Plugin::$instance->editor->is_edit_mode()): ?>
                <script>
                    document.getElementById('<?php echo "wwc_button_{$widget_id}"?>').addEventListener('click', (event) => {
                        event.preventDefault();
                        const _this = event.currentTarget;
                        const wwcButtonLink = _this.getAttribute('href')
                        // facebook pixel event
                        if (typeof fbq === "function") {
                            fbq("track", '<?php echo $settings['facebook_pixel']?>');
                        }
                        // Redirect to WhatsApp
                        window.location.href = wwcButtonLink;
                    });
                </script>
            <?php endif ?>
        <?php endif;
    }
    /* end class */
}
