<?php
/**
 * HTML methods
 *
 * @package     Retheme
 * @category    Core
 * @author      Webforia Studio
 * @version     2.1.0
 */

namespace Webforia;
use Webforia\Helper;


// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// No need to proceed if this class already exists.
if (!class_exists('Webforia\HTML')) {
    class HTML
    {

        /**
         * open tag html helper
         * @param  string $tag  [tag html]
         * @param  array  $args [setting]
         * @return [type]       [html]
         */
        public static function open($args = '', $tag = '')
        {
            $tag = !empty($tag) ? $tag : 'div';

            if (is_array($args)) {
                foreach ($args as $key => $attribute) {
                    if ($key === 'class') {
                        if (is_array($attribute)) {
                            $data[] = $key . '=' . '"' . join(' ', $attribute) . '"';
                        } else {
                            $data[] = $key . '=' . '"' . $attribute . '"';
                        }
                    } elseif ($key === 'id') {
                        $data[] = $key . '=' . '"' . $attribute . '"';
                    } else {
                        $data[] = 'data-' . $key . '=' . '"' . $attribute . '"';
                    }
                }
                $attribute = join(' ', $data);
            } else {
                $attribute = "class='{$args}'";
            }

            return "<{$tag} {$attribute}>";

        }

        /**
         * Close tag helper
         * @param  string $tag  [tag html]
         * @param  string $args [setting]
         * @return [type]       [html]
         */
        public static function close($tag = '', $args = '')
        {
            $tag = !empty($tag) ? $tag : 'div';

            return "</{$tag}>";
        }

        /**
         * open tag slider open
         * @param  array  $args [setting]
         * @return [type]       [html slider]
         */
        public static function before_slider($args = array())
        {
            // breakpoint
            $items_lg = !empty($args['items-lg']) ? $args['items-lg'] : 1;
            $items_md = !empty($args['items-md']) ? $args['items-md'] : 1;
            $items_sm = !empty($args['items-sm']) ? $args['items-sm'] : 1;
            $class_container = !empty($args['class']) ? $args['class'] : '';

            // merge option from slider
            $options = wp_parse_args($args, array(
                'slidesPerView' => $items_lg,
                'spaceBetween' => 10,
                'breakpoints' => array(
                    '960' => array(
                        'slidesPerView' => $items_lg,
                    ),
                    '720' => array(
                        'slidesPerView' => $items_md,
                    ),
                    '320' => array(
                        'slidesPerView' => $items_sm,
                    ),
                ),
                'navigation' => [
                    'nextEl' => '.swiper-button-next',
                    'prevEl' => '.swiper-button-prev',
                ],
                'watchOverflow' => true,
                'setWrapperSize' => true,
                'watchSlidesProgress' => true,
                'watchSlidesVisibility' => true,
            ));

            // same height item
            $sameheight = !empty($args['sameheight']) ? 'rt-swipper--stretch' : '';

            // open slider container
            $html = self::open([
                'id' => !empty($args['id']) ? $args['id'] : 'rt-swiper-' . rand(),
                'class' => ['rt-swiper js-swiper swiper-container', $sameheight, $class_container],
                'options' => htmlspecialchars(json_encode($options)),
            ]);

            // open slider wrapper
            $html .= self::open(['class' => ['swiper-wrapper']]);

            return $html;

        }

        /**
         * Close tag slider
         * @return [type] [html]
         */
        public static function after_slider()
        {
            $html = '</div>';
            $html .= '<div class="swiper-pagination"></div>';
            $html .= '<div class="swiper-button-next"></div>';
            $html .= '<div class="swiper-button-prev"></div>';
            $html .= '</div>';
            return $html;

        }

        /**
         * Show pagination
         * @param array $args [setting query]
         * @return ['html']
         */
        public static function pagination($args = array())
        {
            $format = !empty($args['format']) ? $args['format'] : '';
            $output = '';

            if ($args['pagination_style'] == 'number') {

                $output = '<div class="rt-pagination">' .
                paginate_links(array(
                    'format' => $format,
                    'prev_text' => '<span class="lnr lnr-arrow-left"></span>',
                    'next_text' => '<span class="lnr lnr-arrow-right"></span>',
                ))
                    . '</div>';
            }

            if ($args['pagination_style'] == 'loadmore') {
                $output = '<div class="rt-pagination rt-pagination--loadmore">
                    <div class="rt-pagination__spinner js-' . $args['id'] . '-spinner">
                        <i class="fa fa-spinner fa-spin fa-3x"></i>
                    </div>
                    <a data-triger-id="' . $args['id'] . '" class="rt-pagination__button js-loop-load rt-btn rt-btn--primary">' . __('Load More', RT_THEME_DOMAIN) . '</a>
                </div>';
            }

            return $output;

        }

        /**
         * Header block
         * @param  $args attribute header
         * @return HTML
         */
        public static function header_block($args = array())
        {
            $id = !empty($args['id']) ? $args['id'] : '';
            $class = !empty($args['class']) ? $args['class'] : '';
            $target = !empty($args['target']) ? $args['target'] : '';

            if (!empty($args['title'])) {
                $output = "<div id='{$id}' class='rt-header-block {$class}'>";
                $output .= "<h2 class='rt-header-block__title'>{$args['title']}</h2>";
                if (!empty($args['nav'])):
                    $output .= "<div class='rt-header-block__nav'>";
                    $output .= "<a class='rt-header-block__prev js-swiper-prev'><i class='lnr lnr-arrow-left'></i></a>";
                    $output .= "<a class='rt-header-block__next js-swiper-next'><i class='lnr lnr-arrow-right'></i></a>";
                    $output .= "</div>";
                endif;

                if (!empty($args['desc'])):
                    $output .= "<div class='rt-header-block__desc'>{$args['desc']}</div>";
                endif;

                $output .= '</div>';

                return $output;
            }

        }

        /**
         * show script tag
         * @param  [type] $args [value]
         * @return [type]       [tag]
         */
        public static function script($args)
        {
            $output = '<script>' . $args . '</script>';

            return $output;

        }


    }
}
