<?php
/**
 * Activation Manager
 *
 * @package     Retheme
 * @category    Core
 * @author      Webforia Studio
 * @version     2.1.0
 */

namespace Webforia;

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// No need to proceed if this class already exists.
if (!class_exists('Webforia\Activation')) {
    class Activation
    {
        public $product_name = '';
        public $product_slug = '';
        public $product_key = '';
        public $product_extends = array();
        public $domain = '';

        public function __construct($args = array())
        {
            $this->product_name = !empty($args['product_name']) ? $args['product_name'] : '';
            $this->product_slug = !empty($args['product_slug']) ? $args['product_slug'] : '';
            $this->product_key = !empty($args['product_key']) ? $args['product_key'] : '';
            $this->product_extends = !empty($args['product_extends']) ? $args['product_extends'] : array();
            $this->domain = str_replace(array('www.', 'http://', 'https://'), '', site_url());
        }
        /**
         * Server host license
         *
         * request serverhost without cache
         * @param [type] $action action from server check, activate, deactivate
         * @param [type] $license_key key user
         * @return json responve
         */
        public function license_manager($action)
        {

            // request serverhost without cache
            $serverhost = "https://webforia.id/?time=" . time();
            $domain = $this->domain;
            $secret_key = "5c0a2dd7949698.97710041s";

            // API query parameters
            $api_params['slm_action'] = "slm_{$action}";
            $api_params['secret_key'] = $secret_key;
            $api_params['license_key'] = $this->product_key;
            $api_params['registered_domain'] = $domain;
            $api_params['item_reference'] = $this->product_name;

            // Send query to the license manager server
            $query = esc_url_raw(add_query_arg($api_params, $serverhost));
            $response = wp_remote_get($query, array('timeout' => 100, 'sslverify' => false));

            // Check for error in the response
            if (is_wp_error($response)) {
                echo "Unexpected Error! The query returned with an error. Please check your internet connection";
            }

            // License data.
            return json_decode(wp_remote_retrieve_body($response));

        }

        /**
         * Get max domain for a domain
         *
         * @return number
         */
        public function max_allowed_domains()
        {
            $license = $this->license_manager('check');
            return $license->max_allowed_domains;
        }

        /**
         * Check active domain
         *
         * @return void
         */
        public function registered_domains()
        {
            $license = $this->license_manager('check');
            return $license->registered_domains;
        }

        /**
         * Check domain active on license
         *
         * @param [type] $domain domain check
         * @return boolean
         */
        public function has_domain($site_url = '')
        {
            $domains = $this->registered_domains();

            // Get all domain to array
            $data = array();

            foreach ($domains as $key => $domain) {
                $data[] = $domain->registered_domain;
            }

            // Find domain from array registered domains
            return in_array($site_url, $data);

        }

        /**
         * Get license status from option db
         *
         * @return void
         */
        public function status()
        {
            $product_status = "{$this->product_slug}_status";

            return get_option($product_status);
        }

        /**
         * Check license for current domain
         *
         * @return void
         */
        public function check()
        {

            $license = $this->license_manager('check');

            return $license;
        }

        /**
         * Schedules a hook which will be triggered
         *
         * Get license key from DB
         * Get current website domain
         * Check domain on server
         * Deactive license if not found domain on server
         *
         * @return void
         */
        public function schedule_event()
        {

            $product_status = "{$this->product_slug}_status";
            $product_key = "{$this->product_slug}_key";
            $site_url = $this->domain;

            $key = get_option($product_key);

            if (!empty($key) && !$this->has_domain($domain) && $this->status() == 'active') {
                $this->deactivate();
                update_option($product_status, 'unregistered');
                set_theme_mod($product_status, 'unregistered');
            } else {
                $this->activate();
            }
        }

        /**
         * Check product register for this license key
         *
         * @return bolean
         */
        public function check_product()
        {
            $license = $this->license_manager('check');

            if ($license->product_ref) {
                $product_ref = explode(' - ', $license->product_ref);

                // cek variation
                $product = !empty($product_ref[0]) ? $product_ref[0] : $license->product_ref;

                $product_slug = str_replace(" ", "-", strtolower($product));

                if ($this->product_slug == $product_slug) {
                    return true;
                } else {
                    return false;
                }
            }
        }

        /**
         * Deactive license for current domain
         *
         * @return void
         */
        public function deactivate()
        {

            $license = $this->license_manager('deactivate');
            $product_status = "{$this->product_slug}_status";
            $product_key = "{$this->product_slug}_key";

            // set option
            update_option($product_status, 'deactive');
            update_option($product_key, '');
            set_theme_mod($product_status, 'deactive');
            set_theme_mod($product_key, '');

            // active extend plugin buddling
            foreach ($this->product_extends as $extend) {
                update_option("{$extend}_status", 'deactive');
                update_option("{$extend}_key", '');
                set_theme_mod("{$extend}_status", 'deactive');
                set_theme_mod("{$extend}_key", '');
            }

            $data['result'] = $license->result;
            $data['message'] = $license->message;

            return $data;
        }

        /**
         * Activated license for current domain
         *
         * @return void
         */
        public function activate()
        {
            $product_status = "{$this->product_slug}_status";
            $product_key = "{$this->product_slug}_key";

            // check product license
            if ($this->check_product() == $this->product_slug) {
                $license = $this->license_manager('activate');

                if ($license->result !== 'error') {
                    // set option
                    update_option($product_status, 'active');
                    update_option($product_key, $this->product_key);
                    update_option('product_ref', $license->product_ref);
                    set_theme_mod($product_status, 'active');
                    set_theme_mod($product_key, $this->product_key);
                    set_theme_mod('product_ref', $license->product_ref);

                    // active extend plugin buddling
                    foreach ($this->product_extends as $extend) {
                        update_option("{$extend}_status", 'extended');
                        update_option("{$extend}_key", $this->product_key);
                        set_theme_mod("{$extend}_status", 'extended');
                        set_theme_mod("{$extend}_key", $this->product_key);
                    }

                }

                $data['result'] = $license->result;
                $data['message'] = $license->message;

            } else {
                $data['result'] = 'error';
                $data['message'] = "License not valid or {$this->product_name} not register for this license";
            }

            return $data;
        }

        /**
         * Local server running
         *
         * Check if user is only running the product’s on localhost
         * @return boolean
         */
        public function is_local()
        {
            $site = $_SERVER['SERVER_NAME'];

            $local = array(
                'localhost',
                '127.0.0.1',
                '10.0.0.0/8',
                '172.16.0.0/12',
                '192.168.0.0/16',
                '*.dev',
                '.*local',
                'dev.*',
                'staging.*',
            );

            if (in_array($site, $local)) {
                return false;
            }

        }
    }
}
