/*=================================================
*  AJAX CALL
// =================================================== */

jQuery(document).ready(function ($) {
  var button = $('.js-loop-load');

  button.on("click", function (event) {
    event.preventDefault();

    var block_id = $(this).data("triger-id");
    var element = $("#" + block_id);
    var settings = eval($(this).data("triger-id"));
    var current_page = element.attr("data-page");
    var max_num_pages = element.attr("data-max-paged");
    var trigger = $('[data-triger-id="' + block_id + '"]');
    var spinner = $(".js-" + block_id + "-spinner");

    if ($(this).hasClass("is-loading")) {
      return;
    }

    if ($(this).hasClass("prev")) {
      var page_action = parseInt(current_page) - 1;
    } else {
      var page_action = parseInt(current_page) + 1;
    }

    var data = {
      action: "ajax_loop_result",
      page: page_action,
      settings: settings,
      query: ajax_loop.posts,
      block: block_id,
      check_nonce: ajax_loop.check_nonce,
    };

    jQuery.ajax({
      url: ajax_loop.ajaxurl,
      type: "post",
      dataType: "html",
      data: data,
      beforeSend: function (response) {
        trigger.addClass("is-loading");
        element.addClass("rt-loading");
      },
      success: function (response) {
        var next_page = parseInt(current_page) + 1;
        var prev_page = parseInt(current_page) - 1;

        // check layout masonry
        if (element.hasClass("js-masonry")) {
          var content = $(response);

          // add new content
          var grid = element.append(content).masonry("appended", content);

          // layout Masonry after each image loads
          grid.imagesLoaded().progress(function () {
            grid.masonry("layout").masonry({ horizontalOrder: true });
          });
        } else {
          element.append(response);
        }

        // add new current page
        if ($(this).hasClass("prev")) {
          element.attr("data-page", prev_page);
        } else {
          element.attr("data-page", next_page);
        }

        // add animation
        var newelement = element.find(".flex-item:not(.is-show)");

        jAnimateCSS(newelement, "zoomIn", "300");

        setTimeout(function () {
          element.removeClass("rt-loading");
          trigger.removeClass("is-loading");
        }, 500);

        // remove button if last page
        if (next_page >= max_num_pages) {
          trigger.remove();
        }

        // run countdown class
        if (newelement.find(".wsb-countdown").length > 0) {
          new countdown();
        }
      },
    });
  });
});
