/*=================================================;
/* PRODUCT VARIATION ACTION
/*================================================= */
// added new price form variation
function wwc_variation_select_action() {
    jQuery(document).on("found_variation", "form.variations_form", function(event, variation) {
        document.querySelectorAll("[name='whatsapp_price']").forEach((price) => {
            price.value = variation.display_price;
        });
    });
}
wwc_variation_select_action();
/*=================================================;
/* WIDGET CHAT POPUP
/*================================================= */
// open widget chat if user click trigger icon chat
function wwc_chat_widget() {
    const chat = document.querySelector(".js-chat");
    if (chat == null) {
        return false;
    }
    const triggers = document.querySelectorAll(".js-chat-trigger");
    const close = chat.querySelector(".js-chat-close");
    const chatBox = chat.querySelector(".wwc-chat__inner");
    const autoload = chat.getAttribute("data-autoload");
    if (autoload) {
        setTimeout(function() {
            chat.classList.add("is-active");
            animateCSS(chatBox, "fadeInUp", 300);
        }, 1000);
    }
    triggers.forEach((trigger) => {
        trigger.addEventListener('click', (event) => {
            event.preventDefault();
            if (chat.classList.contains("is-active")) {
                chat.classList.remove("is-active");
                animateCSS(chatBox, "fadeOutDown", 300);
            } else {
                chat.classList.add("is-active");
                animateCSS(chatBox, "fadeInUp", 300);
            }
        });
    });
    close.addEventListener('click', (event) => {
        event.preventDefault();
        chat.classList.remove("is-active");
        animateCSS(chatBox, "fadeOutDown", 300);
    });
}
wwc_chat_widget();
/*=================================================;
/* WIDGET CHAT SUBMIT
/*================================================= 
* Redirect to whatsapp app after submit on whatsapp chat
*/
function wwc_chat_submit() {
    const element = document.querySelector("#whatsapp-form-chat");
    if (element == null) {
        return false
    };
    element.addEventListener('submit', (event) => {
        event.preventDefault();
        const _this = event.currentTarget;
        const whatsappNumber = _this.querySelector('[name="whatsapp_number"]').value;
        const pixelEvent = _this.querySelector('[name="whatsapp_pixel"]').value;
        const whatsappMessage = _this.querySelector('[name="whatsapp_message"]').value;
        // generate whatsapp format
        const whatsappLink = encodeURIComponent(whatsappMessage);
        // redirect whatsapp
        window.location.href = `https://api.whatsapp.com/send?phone=${whatsappNumber}&text=${whatsappLink}`;
        // facebook pixel event
        if (typeof fbq === "function" && pixelEvent != "none") {
            fbq("track", pixelEvent);
        }
    });
}
wwc_chat_submit();
/*=================================================;
/* WHATSAPP CHECKOUT REDIRECT
/*================================================= 
* Handle form submit on whatsapp checkout single product
*/
function wwc_checkout_redirect() {
    // redirect
    document.querySelectorAll(".js-whatsapp-redirect").forEach((whatsappCheckout) => {
        whatsappCheckout.addEventListener('click', (event) => {
            event.preventDefault();
            const helper = new retheme_product_helper();
            const variation = new retheme_product_variation();
            const form = document.querySelector("form.cart");
            if (form == null || whatsappCheckout.classList.contains('disabled')) {
                return false;
            }
            const productData = JSON.parse(form.getAttribute("data-product"));
            const whatsappNumber = form.querySelector('[name="whatsapp_number"]').value;
            const action = form.querySelector("[name='whatsapp_action']").value;
            //get title
            let product = '';
            if (variation.is_variation()) {
                product = productData.variation_title;
            } else {
                product = productData.product_title;
            }
            const price = form.querySelector("[name='whatsapp_price']").value;
            const priceFormat = helper.money_format(price, "Rp");
            const quantity = form.querySelector("[name='quantity']").value;
            const total = parseInt(quantity * price);
            const totalFormat = helper.money_format(total);
            const pixelEvent = form.querySelector("[name ='whatsapp_pixel']").value;
            const getvariationID = form.querySelector('input[name="variation_id"]');
            const getProductID = form.querySelector('input[name="whatsapp_product_id"]');
            let whatsappMessage = form.querySelector("[name='whatsapp_message']").value;
            // get product id
            let productID = "";
            if (getvariationID != null) {
                productID = getvariationID.value
            } else {
                productID = getProductID.value;
            }
            //replace link
            whatsappMessage = whatsappMessage.replace(/{{product}}/i, product);
            whatsappMessage = whatsappMessage.replace(/{{price}}/i, priceFormat);
            whatsappMessage = whatsappMessage.replace(/{{total}}/i, totalFormat);
            whatsappMessage = whatsappMessage.replace(/{{quantity}}/i, quantity);
            // generate whatsapp format
            const whatsappLink = encodeURIComponent(whatsappMessage);
            // redirect whatsapp
            window.location.href = `https://api.whatsapp.com/send?phone=${whatsappNumber}&text=${whatsappLink}`;
            // facebook pixel event
            if (typeof fbq == "function" && pixelEvent != "none") {
                fbq("track", pixelEvent, {
                    content_type: "product",
                    content_ids: productID,
                    content_name: product,
                    currency: "IDR",
                    value: price,
                });
            }
        });
    })
}
wwc_checkout_redirect();