class WhatsApp_Create_Order {
    constructor() {
        this.createOrder();
    }
    createOrder() {
        const forms = document.querySelectorAll("form.js-whatsapp-create-order");
        forms.forEach((form) => {
            const button = form.querySelector("button");
            const message = form.querySelector(".order_form_message");
            form.addEventListener("submit", (event) => {
                event.preventDefault();
                const _this = event.currentTarget;
                const getQuantity = document.querySelector('form.cart input[name="quantity"]');
                const getvariationID = document.querySelector('form.cart input[name="variation_id"]');
                const getProductID = document.querySelector('form.cart input[name="whatsapp_product_id"]');
                const getPixelEvent = document.querySelector('form.cart input[name="whatsapp_pixel"]');
                // get product id
                let productID = "";
                if (getvariationID != null) {
                    productID = getvariationID.value;
                } else {
                    productID = getProductID.value;
                }
                // ajax run
                jQuery.ajax({
                    url: "?wc-ajax=whatsapp_create_order",
                    type: "POST",
                    data: {
                        field: serialize(_this),
                        product_id: productID,
                        quantity: getQuantity.value,
                    },
                    beforeSend: function(response) {
                        _this.classList.add("rt-loading");
                        button.classList.add("is-loading");
                    },
                    success: function(results) {
                        // redirect whatsapp
                        if (results.error == false) {
                            window.location.href = results.link;
                            // facebook pixel event
                            if (typeof fbq === "function" && getPixelEvent.value != null && getPixelEvent.value != "none") {
                                fbq("track", getPixelEvent.value);
                            }
                        }
                        // send message
                        message.innerHTML = results.message;
                        _this.classList.remove("rt-loading");
                        button.classList.remove("is-loading");
                    },
                });
            });
        });
    }
}
new WhatsApp_Create_Order();