
<?php
// Product attribute
$product_name = 'Webforia WA Chat';
$product_slug = 'webforia-wa-chat';
$product_url = 'https://webforia.id/webforia-wa-chat';

// Form value
$license_key = wc_clean(wp_unslash($_POST['product_license_key']));
$license_action = wc_clean(wp_unslash($_POST['product_license_submit']));

// API Manager
$license = New Webforia\Activation(array(
    'product_name' => $product_name,
    'product_slug' => $product_slug,
    'product_key' => $license_key,
));

if ($license_action) {
    if ($license_action == 'activate') {
        $manager = $license->activate();
    } else {
        $manager = $license->deactivate();
    }
}

$status = !empty(get_option("{$product_slug}_status") == 'extended')? get_option("{$product_slug}_status"):$license->status();

?>
<div class="bulma theme-panel">
    <section class="page-header">
        <h1 class="title"><?php echo $product_name ?> Lisensi</h1>
    </section>

    <div class="columns">
        <div class="column is-6">

            <?php
            if ($manager['result'] == 'error') {
                echo wwc_admin_notification($manager['message'], 'error');
            }
            if ($manager['result'] == 'success') {
                echo wwc_admin_notification($manager['message']);
            }
            ?>

            <div class="panel bg-light">

                <div class="panel-heading">
                    Lisensi

                    <?php if ($license->is_local()): ?>
                        <span class="tag is-success is-capitalized" style="float: right"><?php echo $license->status() ?></span>
                    <?php elseif ($status === 'active'): ?>
                        <span class="tag is-success is-capitalized" style="float: right"><?php echo $status ?></span>
                    <?php elseif ($status === 'extended'): ?>
                        <span class="tag is-success is-capitalized" style="float: right"><?php echo $status ?></span>
                    <?php else: ?>
                        <span class="tag is-warning is-capitalized" style="float: right"><?php echo 'Deactive' ?></span>
                    <?php endif?>

                </div>

                <div class="panel-block">
                    <div>
                       <?php if ($status !== 'extended'): ?>

                       <div class="content">
                            <?php if ($license->is_local()): ?>
                                <p style="margin: 15px 0;">Anda sedang menggunakan theme ini di localhost server, semua fitur <strong>Premium</strong> akan aktif pada server lokal. Anda wajib memasukan lisensi ketika di hosting atau server online </p>
                            <?php else: ?>
                                <p style="margin: 10px 0;">Masukan kunci lisensi Anda untuk dapat menggunakan semua fitur premium, update, dan support. Bila Anda tidak memiliki kunci lisensi silakan kunjungi halaman berikut-> <a target="_blank" href="<?php echo $product_url ?>">kunci lisensi</a></p>
                            <?php endif?>
                       </div>

                        
                        <form action="" method="post">
                            <div class="field">
                                <label class="label">Lisensi Key</label>

                                <?php if ($license->is_local()): ?>
                                    <input class="input" id="product_license_key" name="product_license_key" type="password" value="localhost" disabled />
                                <?php else: ?>
                                    <input class="input" id="product_license_key" name="product_license_key" type="text" value="<?php echo get_option("{$product_slug}_key"); ?>"/>
                                <?php endif?>

                            </div>
                            <div style="margin-bottom: 20px">

                                <?php if ($license->is_local()): ?>
                                    <input class="button is-info" name="product_license_submit" type="submit" value="Activate License" disabled />
                                <?php else: ?>
                                    <button class="button" name="product_license_submit" type="submit" value="reset">Reset</button>
                                    <button class="button is-info" name="product_license_submit" type="submit" value="activate">Aktifkan</button>
                                <?php endif?>

                            </div>
                        </form>

                        <?php else: ?>
                            <p>Lisensi mengikuti tema, plugin ini hanya akan aktif jika menggunakan tema terkait</p>
                        <?php endif ?>

                    </div>

                </div>

            </div>
        </div>
    </div>

</div>