<?php
namespace Webforia_Whatsapp\Admin;

class Admin_Init
{

    public function __construct()
    {
        add_action('admin_init', array($this, 'include_part'));
        add_action('admin_enqueue_scripts', array($this, 'register_scripts'), 999);
        add_action('admin_menu', array($this, 'add_menu_panel'));
        add_action('admin_notices', array($this, 'tabs'), 1);

    }

    public function include_part()
    {
        include_once dirname(__FILE__) . '/functions.php';
    }

    public function register_scripts()
    {
        wp_enqueue_style('fontawesome', WEBFORIA_WHATSAPP_CHAT_ASSETS . '/admin/assets/fontawesome/css/all.min.css', '5.14.0');
        wp_enqueue_style('admin-carbon-fields', WEBFORIA_WHATSAPP_CHAT_ASSETS . '/admin/assets/css/carbon-field.css', '1.2.3');
        wp_enqueue_style('retheme-admin', WEBFORIA_WHATSAPP_CHAT_ASSETS . '/admin/assets/css/retheme-admin.css');
        wp_enqueue_script('retheme-admin', WEBFORIA_WHATSAPP_CHAT_ASSETS . '/admin/assets/js/retheme-admin.js', array('jquery'), '1.0.0', true);
    }

    public function tabs()
    {
        $page = !empty($_GET['page']) ? $_GET['page'] : false;

        if ($page == 'crb_carbon_fields_container_whatsapp.php' || $page == 'webforia-whatsapp-chat-license') {
            wwc_admin_get_template_part('global/tabs');
        }

    }

    /**
     * Add menu panel
     */
    public function add_menu_panel()
    {
        add_submenu_page('', 'WhatsApp Chat License', 'WhatsApp Chat License', 'manage_options', 'webforia-whatsapp-chat-license', function () {
            wwc_admin_get_template_part('license');
        }, 99);

    }

}

new Admin_Init();
