<?php 
$product = wc_get_product(get_the_ID());

$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$average = $product->get_average_rating();

$post_total = get_post_meta(get_the_ID(), 'total_sales', true);
$post_view = get_post_meta(get_the_ID(), 'wp_post_views_count', true);

$total = !empty($post_total)? number_format($post_total,0,"","."): '';
$view = !empty($post_view)? number_format($post_view ,0,"","."): '';

if(wsb_option('product_fomo_style', 'inline') == 'inline'){
	$wbs_class = 'wsb-product-social-proof--inline';
}else{
	$wbs_class = 'wsb-product-social-proof--list';
}
?>

<div class="wsb-product-social-proof js-wsb-product-social-proof <?php echo esc_attr( $wbs_class )?>" data-product-id="<?php echo get_the_ID()?>">

	<?php if ( $rating_count > 0 && wc_review_ratings_enabled() && wsb_option('product_fomo_style', 'inline') == 'inline'): ?>
	<div class="wsb-product-social-proof__item wsb-rating">
		<span class="rt-icon">
			<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-star-fill" viewBox="0 0 16 16">
				<path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
			</svg>
		</span>
		<?php echo wp_sprintf( __("%s (%s review)", WEBFORIA_SHOP_BOOSTER_DOMAIN), $average, $review_count ) ?>
	</div>
	<?php endif ?>

	<?php if ($view && !empty(wsb_option('product_count_view_text', 'Views'))): ?>
	<div class="wsb-product-social-proof__item wsb-product-view">
	    <span class="rt-icon">
			<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye-fill" viewBox="0 0 16 16">
				<path d="M10.5 8a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0z"/>
				<path d="M0 8s3-5.5 8-5.5S16 8 16 8s-3 5.5-8 5.5S0 8 0 8zm8 3.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7z"/>
			</svg>
		</span>
	    <span id="post_counter_<?php the_ID()?>" class="post_counter"><?php echo $view ?></span>
	    <?php echo wsb_option('product_count_view_text', 'Views') ?>
	</div>
	<?php endif?>

	<?php if ($total && !empty(wsb_option('product_total_sales_text', 'Sold'))): ?>
	<div class="wsb-product-social-proof__item wsb-total-sales">
	    <span class="rt-icon">
			<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-truck" viewBox="0 0 16 16">
				<path d="M0 3.5A1.5 1.5 0 0 1 1.5 2h9A1.5 1.5 0 0 1 12 3.5V5h1.02a1.5 1.5 0 0 1 1.17.563l1.481 1.85a1.5 1.5 0 0 1 .329.938V10.5a1.5 1.5 0 0 1-1.5 1.5H14a2 2 0 1 1-4 0H5a2 2 0 1 1-3.998-.085A1.5 1.5 0 0 1 0 10.5v-7zm1.294 7.456A1.999 1.999 0 0 1 4.732 11h5.536a2.01 2.01 0 0 1 .732-.732V3.5a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 .294.456zM12 10a2 2 0 0 1 1.732 1h.768a.5.5 0 0 0 .5-.5V8.35a.5.5 0 0 0-.11-.312l-1.48-1.85A.5.5 0 0 0 13.02 6H12v4zm-9 1a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm9 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2z"/>
			</svg>
		</span>
	    <span id="order_counter_<?php the_ID()?>" class="sales_counter"><?php echo $total?></span>
	    <?php echo wsb_option('product_total_sales_text', 'Sold') ?>
	</div>
	<?php endif?>
	
	
</div>