<?php

/**
 * Plugin Name: Webforia Shop Booster
 * Description: Plugin untuk optimasi toko online berbasis WooCommerce dan tema dari Webforia Studio
 * Plugin URI:  https://webforia.id
 * Version:     2.4.0
 * Author:     Webforia Studio
 * Author URI:  https://webforia.id/webforia-shop-booster
 * Text Domain: webforia-shop-booster
 * Requires at least: 5.0
 * Tested up to: 5.6
 * Stable tag: 2.0
 * WC requires at least: 5.0
 * WC tested up to: 5.0
 */

if (!defined('ABSPATH')) {
    exit;
}

define('WEBFORIA_SHOP_BOOSTER_TEMPLATE', plugin_dir_path(__FILE__));
define('WEBFORIA_SHOP_BOOSTER_ASSETS', plugin_dir_url(__FILE__));
define('WEBFORIA_SHOP_BOOSTER_DOMAIN', 'webforia-shop-booster');

/*=================================================;
/* LOAD THIS PLUGIN AFTER RETHEME LOAD
/*================================================= */
function wsb_plugin_loaded() {
    // load woocommerce if woocommerce plugin active
    if (class_exists('woocommerce')) {
        require_once WEBFORIA_SHOP_BOOSTER_TEMPLATE . '/plugin.php';
        require_once WEBFORIA_SHOP_BOOSTER_TEMPLATE . '/includes/class-templates.php';
        require_once WEBFORIA_SHOP_BOOSTER_TEMPLATE . '/functions.php';
        require_once WEBFORIA_SHOP_BOOSTER_TEMPLATE . '/includes/include.php';
    }

    // update plugin
    $check_update = Puc_v4_Factory::buildUpdateChecker('https://gitlab.com/rereyossi/webforia-shop-booster', __FILE__, 'webforia-shop-booster');
    $check_update->setBranch('stable_release_v2');

    do_action('wsb_after_plugin_loaded');
}

add_action('rt_after_setup_theme', 'wsb_plugin_loaded');
