<?php
namespace Webforia_Shop_Booster;

class Plugin_Final
{

    public function __construct()
    {
        // scripts
        add_action('wp_enqueue_scripts', [$this, 'scripts']);

        add_action('plugins_loaded', [$this, 'load_plugin_textdomain']);
        add_filter('body_class', [$this, 'add_body_class']);

        load_plugin_textdomain('webforia-shop-booster', false, dirname(plugin_basename(__FILE__)) . '/languages/');

    }

    /**
     * Add main scripts
     * 
     * @hook action wp_enqueue_scripts
     * @return void
     */
    public function scripts()
    {
       
        wp_enqueue_style('shop-booster', WEBFORIA_SHOP_BOOSTER_ASSETS . 'assets/css/shop-booster.min.css', false, '2.4.0');

    }

    /**
     * Add css clas on body class
     *
     * @hook filter body_class
     * @param [type] $classes
     * @return void
     */
    public function add_body_class($classes)
    {
        $classes[] = 'webforia-shop-booster shop-booster';
        return $classes;
    }


}

new Plugin_Final;
