<?php
/**
 * Added text on variable string
 * Change range price to human text like "price starter"
 * @version 1.0.0
 */
namespace Webforia_Shop_Booster;
class Variable_Price
{
    public function __construct()
    {
        add_filter('woocommerce_variable_sale_price_html', [$this, 'set_variable_price'], 10, 2);
        add_filter('woocommerce_variable_price_html', [$this, 'set_variable_price'], 10, 2);

    }

    /**
     * Add string before text
     * Change default variation price format on product loop
     * This function not work for product variation
     *
     * @hook filter woocommerce_variable_sale_price_html
     * @hook filter woocommerce_variable_price_html
     * @param [type] $price
     * @param [type] $product
     * @return void
     */
    public function set_variable_price($price, $product)
    {
        // Main Price
        if ($product->get_variation_price('min', true) !== $product->get_variation_price('max', true) && wsb_option('variable_price', true)) {
            $prices = array($product->get_variation_price('min', true), $product->get_variation_price('max', true));
            $price = $prices[0] !== $prices[1] ? wc_price($prices[0]) : wc_price($prices[0]);

            // Sale Price
            $prices = array($product->get_variation_regular_price('min', true), $product->get_variation_regular_price('max', true));
            sort($prices);
            $saleprice = $prices[0] !== $prices[1] ? wc_price($prices[0]) : wc_price($prices[0]);

            if ($price !== $saleprice) {
                $price = sprintf(__('Starting: <del>%1$s</del> %2$s', 'webforia-shop-booster'), $saleprice, $price);
            } else {
                $price = sprintf(__('Starting: %1$s', 'webforia-shop-booster'), $saleprice);
            }
        }
        return $price;
    }
}

new Variable_Price;