<?php
namespace Webforia_Shop_Booster;

class Sales_Notif
{
    public function __construct()
    {
        add_action('rt_footer', [$this, 'render'], 5);
        add_action('wp_enqueue_scripts', [$this, 'ajax_scripts']);
        add_action('rest_api_init', [$this, 'restapi']);
    }

    /**
     * Ajax call rest api
     *
     * @return void
     */
    public function ajax_scripts()
    {
        if (wsb_option('sales_notif', true) && wsb_check_order()) {
            wp_enqueue_script('shop-booster-sales-notif', WEBFORIA_SHOP_BOOSTER_ASSETS . 'assets/js/sales-notif.min.js', array('jquery'), '2.2.0', true);
            wp_localize_script('shop-booster-sales-notif', 'shop_booster_sales_notif',
                array(
                    'apiurl' => site_url() . '/wp-json/wsb/v1/sales-notif',
                )
            );
        }
    }

    /**
     * REST API
     *
     * @hook action rest_api_init
     * @return void
     */
    public function restapi()
    {
        register_rest_route('wsb/v1', 'sales-notif', array(
            'methods'  => 'GET',
            'callback' => [$this, 'ajax_rest_result'],
        ));
    }

    /**
     * Result ajax
     */
    public function ajax_rest_result()
    {

        // use if order empty
        $sale = array();

        $orders = wc_get_orders(array(
            'status' => 'completed',
            'limit'  => wsb_option('sales_notif_number', 5),
        ));

        // get all country
        $countries_obj        = new \WC_Countries();
        $country_states_array = $countries_obj->get_states();

        foreach ($orders as $key => $order) {

            $items      = $order->get_items();
            $country    = $order->get_billing_country();
            $state      = $order->get_billing_state();
            $first_name = $order->get_billing_first_name();
            $last_name  = $order->get_billing_last_name();

            // get state name string
            $state_name = $country_states_array[$country][$state];

            $index = 0;
            foreach ($items as $key => $item) {

                $date_normal = $order->get_date_completed()->date('U');
                $date        = human_time_diff($date_normal, current_time('timestamp')) . ' ' . __('ago', 'webforia-shop-booster');

                // replace message
                $find    = array('{{first_name}}', '{{last_name}}', '{{state}}');
                $replace = array($first_name, $last_name, $state_name);
                $arr     = wsb_option('sales_notif_text', 'Someone in {{state}} just bought');

                // product name
                // remove product variation
                if (wsb_option('sales_notif_variation_name', true) == false) {
                    $product_name_variable = explode('-', $item->get_name());
                    $product_name          = !empty($product_name_variable[0]) ? $product_name_variable[0] : $item->get_name();
                } else {
                    $product_name = $item->get_name();
                }

                // image
                if (!empty(wp_get_attachment_image_src(get_post_thumbnail_id($item->get_product_id()), 'thumbnail')[0])) {
                    $product_image = wp_get_attachment_image_src(get_post_thumbnail_id($item->get_product_id()), 'thumbnail')[0];
                } else {
                    $product_image = wc_placeholder_img_src();
                }

                $message = str_replace($find, $replace, $arr);

                $sale[$key]['product_id']         = $item->get_product_id();
                $sale[$key]['product_permalink']  = get_permalink($item->get_product_id());
                $sale[$key]['product_title']      = $product_name;
                $sale[$key]['product_thumbnail']  = $product_image;
                $sale[$key]['billing_first_name'] = $order->get_billing_first_name();
                $sale[$key]['order_billing_city'] = $order->get_billing_city();
                $sale[$key]['order_message']      = $message;
                $sale[$key]['order_date']         = $date;

                $index++;
            }

        }

        // reindex array key and print as json
        wp_send_json(array_values($sale));

    }

    /**
     * Render sales notif to front end
     *
     * @hook action rt_footer
     * @return void
     */
    public function render()
    {
        if (wsb_option('sales_notif', true) && wsb_check_order()) {
            wsb_get_template_part('sales-notif');
        }

    }

}

new Sales_Notif;
