<?php
namespace Webforia_Shop_Booster;

class Resi
{
    public function __construct()
    {
        add_action('add_meta_boxes', [$this, 'register_metabox'], 20);
        add_action('save_post', [$this, 'save'], 10, 1);
        add_action('woocommerce_email_before_order_table', [$this, 'send_email'], 20, 4);

    }
    
    /**
     * Get resi metabox value
     *
     * @hook
     * @return void
     */
    public function metabox()
    {

        $data['resi'] = get_post_meta(get_the_ID(), 'resi', true);

        wsb_get_template_part('form-resi', $data);

    }
    /**
     * Register metabox on sidebar order detail
     *
     * @hook action add_meta_boxes
     * @return void
     */
    public function register_metabox()
    {
        add_meta_box("Shipping Tracking", "Shipping Tracking", [$this, 'metabox'], "shop_order", "side", "high", null);
    }

    /**
     * Save metabox after save post
     *
     * @param [type] $post_id
     * @return void
     */
    public function save($post_id)
    {
        // We need to verify this with the proper authorization (security stuff).

        // Check if our nonce is set.
        if (!isset($_POST['resi_nonce'])) {
            return $post_id;
        }
        $nonce = $_REQUEST['resi_nonce'];

        //Verify that the nonce is valid.
        if (!wp_verify_nonce($nonce)) {
            return $post_id;
        }

        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $post_id;
        }

        // Check the user's permissions.
        if ('shop_order' == $_POST['post_type']) {

            if (!current_user_can('edit_page', $post_id)) {
                return $post_id;
            }
        } else {

            if (!current_user_can('edit_post', $post_id)) {
                return $post_id;
            }
        }
        // --- Its safe for us to save the data ! --- //

        // Sanitize user input  and update the meta field in the database.
        $resi = sanitize_text_field($_POST['resi']);
        update_post_meta($post_id, 'resi', $resi);
    }

    /**
     * Send Email Resi
     * send if order completed
     *
     * @hook woocommerce_email_before_order_table
     */
    public function send_email($order, $sent_to_admin, $plain_text, $email)
    {
        
        $resi = sanitize_text_field($_POST['resi']);

        if (!empty($resi)) {
            if (($email->id == 'customer_completed_order' || $email->id == 'customer_invoice' ) && $order->get_status() == 'completed') {
                echo "<p>Nomor Resi: <strong>{$resi}</strong>, cek pesanan anda <a href='https://cekresi.com/?noresi=" . $resi . "'>disini</a></p>";
            }
        }

    }

}

new Resi;
