<?php
namespace Webforia_Shop_Booster;
class Product_Trust
{
    public function __construct()
    {
        add_action('woocommerce_single_product_summary', [$this, 'render'], 35);
        add_action('woocommerce_after_cart_totals', [$this, 'render']);
        add_action('woocommerce_review_order_after_submit', [$this, 'render']);

    }

    /**
     * Show total sale
     *
     * @return html
     */
    public function render()
    {

        $trust_badges = wsb_option('trust_badges_view', ['product', 'cart', 'checkout']);

        if (in_array('product', $trust_badges) && rt_is_woocommerce('product')) {
            wsb_get_template_part('product-trust');
        }

        if (in_array('cart', $trust_badges) && rt_is_woocommerce('cart')) {
            wsb_get_template_part('product-trust');
        }

        if (in_array('checkout', $trust_badges) && rt_is_woocommerce('checkout')) {
            wsb_get_template_part('product-trust');
        }

    }

}
new Product_Trust;
