<?php
namespace Webforia_Shop_Booster;

class Product_Fomo
{
    public function __construct()
    {
        // add ajax show product total sales
        add_action('wp_enqueue_scripts', [$this, 'ajax_sales_count_scripts']);
        add_action('rest_api_init', [$this, 'restapi']);

        if (wsb_option('product_fomo_style', 'inline') === 'inline') {
            add_action('woocommerce_single_product_summary', [$this, 'render'], 8);
            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
        } else {
            add_action('woocommerce_single_product_summary', [$this, 'render'], 20);
        }

        add_action('woocommerce_single_product_summary', [$this, 'render_product_extra'], 35);

    }

    /**
     * Ajax order total load scripts
     *
     */
    public function ajax_sales_count_scripts()
    {
        if (is_singular('product') && (wsb_option('product_count_view', true) || wsb_option('product_total_sales', true))) {
            wp_enqueue_script('shop-booster-fomo', WEBFORIA_SHOP_BOOSTER_ASSETS . 'assets/js/product-fomo.min.js', array('jquery'), '1.1.0', true);
            wp_localize_script('shop-booster-fomo', 'shop_booster_fomo',
                array(
                    'apiurl' => site_url().'/wp-json/wsb/v1/product-fomo',
                )
            );
        }
    }

    /**
     * Register Rest API
     *
     * @return void
     */
    public function restapi()
    {
        register_rest_route('wsb/v1', 'product-fomo', array(
            'methods'  => 'GET',
            'callback' => [$this, 'ajax_rest_result'],
        ));

    }

    /**
     * Get rest API result
     * get product count
     * get product view
     *
     * @param [type] $result
     * @return void
     */
    public function ajax_rest_result($result)
    {
        wp_send_json(array(
            'sales' => $this->ajax_sales_count_result($result),
            'count' => $this->ajax_post_count_result($result),
        ));
    }
    /**
     * Ajax order total result
     */
    public function ajax_sales_count_result($result)
    {
        if (!empty($result['post_id'])) {
            $postID = intval($result['post_id']);
            return number_format(get_post_meta($postID, 'total_sales', true),0,"",".");
        } else {
            return 1;
        }

    }

    /**
     * Count post view
     *
     * @param [type] $result
     * @return void
     */
    public function ajax_post_count_result($result)
    {
        if (wsb_option('post_counter', true) && !empty($result['post_id'])) {
            $postID    = intval($result['post_id']);
            $count_key = 'wp_post_views_count';

            if (!current_user_can('administrator')) {

                $count = get_post_meta($postID, 'wp_post_views_count', true);
                if ($count == '') {
                    $count = 0;
                    delete_post_meta($postID, 'wp_post_views_count');
                    update_post_meta($postID, 'wp_post_views_count', '1');
                } else {
                    ++$count;
                    update_post_meta($postID, 'wp_post_views_count', $count);
                }
            }
            $post_count = number_format(get_post_meta($postID, 'wp_post_views_count', true),0,"",".");
            return $post_count;
        } else {
            return 1;
        }
    }

    /**
     * Show total sale
     *
     * @return html
     */
    public function render()
    {
        wsb_get_template_part('product-social-proof');
    }

    /*
     * Render produk extra
     */
    public function render_product_extra()
    {
        wsb_get_template_part('product-list');
    }

}
new Product_Fomo;
