<?php
namespace Webforia_Shop_Booster;

class Discount
{
    public function __construct()
    {
        // remove default badges sale
        add_filter('woocommerce_sale_flash', [$this, 'sale_badges'], 10, 3);
    }

    /**
     * Show persen to badges
     *
     *
     * @param [type] $html
     * @param [type] $post
     * @param [type] $product
     * @return void
     */
    public function sale_badges($html, $post, $product)
    {
        global $product;
        $percentage = 0;
        $max_percentage = 0;

        if (!$product->is_on_sale()) {
            return;
        }
        if ($product->is_type('simple')) {
            $max_percentage = (($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100;
        } elseif ($product->is_type('variable')) {

            foreach ($product->get_children() as $child_id) {
                $variation = wc_get_product($child_id);
                $price = $variation->get_regular_price();
                $sale = $variation->get_sale_price();

                if ($price != 0 && !empty($sale)) {
                    $percentage = ($price - $sale) / $price * 100;
                }
                if ($percentage > $max_percentage) {
                    $max_percentage = $percentage;
                }
            }
        }

        if ($max_percentage > 0 && wsb_option('discount_badges', true)) {
            $percentage = round($max_percentage);

            $discount_badges = str_replace('{{discount}}', "<span class='product_onsale'>{$percentage}%</span>", wsb_option('discount_badges_text', 'Discount {{discount}}'));

            $html = "<span class='onsale'>" . $discount_badges . "</span>";
        }else{
            return false;
        }

        return $html;

    }

}
new Discount;
