<?php
namespace Webforia_Shop_Booster;

use Retheme\Customizer_Base;
use Retheme\Helper;

class Customizer extends Customizer_Base
{
    public function __construct()
    {

        $this->panel();
        $this->countdown();
        $this->discount();
        $this->fomo();
        $this->product_trust();
        $this->sales_notif();

    }

    public function panel()
    {

        $this->add_panel('shop_booster', [
            'title' => __('Shop Booster', 'webforia-shop-booster'),
            'priority' => 170,
        ]);
    }

    public function countdown()
    {
        $section = 'woocommerce_countdown_section';

        $this->add_section('shop_booster', [
            'woocommerce_countdown' => [__('Countdown Timer', 'webforia-shop-booster')],
        ]);

        $this->add_field([
            'type' => 'toggle',
            'settings' => 'countdown_timer_shop',
            'label' => __('Countdown On Shop', 'webforia-shop-booster'),
            'desctiption' => __('Choose whether to display display on shop page', 'webforia-shop-booster'),
            'section' => $section,
            'default' => true,
        ]);

        $this->add_field([
            'type' => 'toggle',
            'settings' => 'countdown_timer',
            'label' => __('Countdown On Single', 'webforia-shop-booster'),
            'desctiption' => __('Choose whether to display display on product page', 'webforia-shop-booster'),
            'section' => $section,
            'default' => true,
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => 'countdown_timer_text',
            'label' => __('Timer Text', 'webforia-shop-booster'),
            'section' => $section,
            'default' => __('Hurry up! Sale Ends in', 'webforia-shop-booster'),
            'active_callback' => [
                [
                    'setting' => 'countdown_timer',
                    'operator' => '==',
                    'value' => true,
                ],
            ],
        ]);

    }

    public function discount()
    {
        $section = 'woocommerce_discount_badges_section';

        $this->add_section('shop_booster', [
            'woocommerce_discount_badges' => [__('Discount Badges', 'webforia-shop-booster')],
        ]);

        $this->add_field([
            'type' => 'toggle',
            'settings' => 'discount_badges',
            'label' => __('Discount Badges', 'webforia-shop-booster'),
            'section' => $section,
            'default' => true,
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => 'discount_badges_text',
            'label' => __('Discount Text', 'webforia-shop-booster'),
            'description' => 'use {{discount}} for show number discount',
            'section' => $section,
            'default' => __('Discount {{discount}}', 'webforia-shop-booster'),
            'active_callback' => [
                [
                    'setting' => 'discount_badges',
                    'operator' => '==',
                    'value' => true,
                ],
            ],
        ]);

    }

    public function fomo()
    {

        $section = 'woocommerce_social_proof_section';

        $this->add_section('shop_booster', [
            'woocommerce_social_proof' => [__('Product FOMO', 'webforia-shop-booster')],
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'product_fomo_style',
            'label' => __('Style', 'webforia-shop-booster'),
            'section' => $section,
            'default' => 'inline',
            'multiple' => 1,
            'choices' => [
                'inline' => 'Inline',
                'list' => 'List',
            ],
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => 'product_count_view_text',
            'label' => __('Total View', 'webforia-shop-booster'),
            'description' => __('Show total view each product', 'webforia-shop-booster'),
            'section' => $section,
            'default' => __('views', 'webforia-shop-booster'),
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => 'product_total_sales_text',
            'label' => __('Total Sales', 'webforia-shop-booster'),
            'description' => __('Show total sold each product', 'webforia-shop-booster'),
            'section' => $section,
            'default' => __('sold', 'webforia-shop-booster'),
        ]);

        $this->add_header([
            'label' => __('Additional product information', 'webforia-shop-booster'),
            'settings' => 'product_list',
            'section' => $section,
        ]);

        $this->add_field([
            'type' => 'toggle',
            'settings' => 'product_list',
            'label' => __('Extra Information', 'webforia-shop-booster'),
            'section' => $section,
            'default' => true,
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => 'product_list_title',
            'label' => __('Product Information', 'webforia-shop-booster'),
            'section' => $section,
            'default' => __('Free worldwide shipping', 'webforia-shop-booster'),
            'active_callback' => [
                [
                    'setting' => 'product_list',
                    'operator' => '==',
                    'value' => true,
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'repeater',
            'label' => __('Product List', 'webforia-shop-booster'),
            'section' => $section,
            'row_label' => [
                'type' => 'field',
                'value' => __('your custom value', 'webforia-shop-booster'),
                'field' => 'text',
            ],
            'button_label' => __('Add new list', 'webforia-shop-booster'),
            'settings' => 'product_list_item',
            'fields' => [
                'text' => [
                    'type' => 'text',
                    'label' => __('Text', 'webforia-shop-booster'),
                ],
            ],
            'active_callback' => [
                [
                    'setting' => 'product_list',
                    'operator' => '==',
                    'value' => true,
                ],
            ],
        ]);

    }

    public function product_trust()
    {

        $section = 'woocommerce_trust_section';

        $this->add_section('shop_booster', [
            'woocommerce_trust' => [__('Trust Badges', 'webforia-shop-booster')],
        ]);

        $this->add_field([
            'type' => 'text',
            'settings' => 'trust_badges_title',
            'label' => __('Title', 'webforia-shop-booster'),
            'section' => $section,
            'default' => __('Guaranteed Safe Checkout', 'webforia-shop-booster'),
        ]);

        $this->add_field([
            'type' => 'image',
            'settings' => 'trust_badges_image',
            'label' => __('Trust Badges', 'webforia-shop-booster'),
            'description' => __('Upload Image for trust your customer', 'webforia-shop-booster'),
            'section' => $section,
            'choices' => [
                'save_as' => 'id',
            ],
        ]);

        $this->add_field([
            'type' => 'multicheck',
            'settings' => 'trust_badges_view',
            'label' => __('Show trust badges on pages', 'webforia-shop-booster'),
            'section' => $section,
            'default' => [
                'product', 'cart', 'checkout',
            ],
            'choices' => [
                'product' => __('Product', 'webforia-shop-booster'),
                'cart' => __('Cart', 'webforia-shop-booster'),
                'checkout' => __('Checkout', 'webforia-shop-booster'),
            ],
        ]);

    }

    public function sales_notif()
    {
        $section = 'woocommerce_sales_notif_section';

        $this->add_section('shop_booster', [
            'woocommerce_sales_notif' => [__('Sales Notif', 'webforia-shop-booster')],
        ]);

        $this->add_field([

            'type' => 'toggle',
            'settings' => 'sales_notif',
            'label' => __('Sales Notif', 'webforia-shop-booster'),
            'description' => __('Show recent order notifcations', 'webforia-shop-booster'),
            'section' => $section,
            'default' => true,
        ]);

        $this->add_field([
            'type' => 'number',
            'settings' => 'sales_notif_number',
            'label' => __('Number', 'webforia-shop-booster'),
            'section' => $section,
            'default' => 5,
            'choices' => [
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ],
            'active_callback' => [
                [
                    'setting' => 'sales_notif',
                    'operator' => '==',
                    'value' => true,
                ],
            ],
        ]);
        $this->add_field([
            'type' => 'text',
            'settings' => 'sales_notif_text',
            'label' => __('Headline', 'webforia-shop-booster'),
            'description' => 'Replace text order attribute with: {{first_name}}, {{last_name}}, {{state}}',
            'default' => __('Someone in {{state}} just bought', 'webforia-shop-booster'),
            'section' => $section,
            'active_callback' => [
                [
                    'setting' => 'sales_notif',
                    'operator' => '==',
                    'value' => true,
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'select',
            'label' => __('Animation', 'webforia-shop-booster'),
            'section' => $section,
            'settings' => 'sales_animation',
            'default' => 'slideInUp',
            'choices' => Helper::get_animation_in(),
            'active_callback' => [
                [
                    'setting' => 'sales_notif',
                    'operator' => '==',
                    'value' => true,
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'toggle',
            'settings' => 'sales_notif_close',
            'label' => __('Close Button', 'webforia-shop-booster'),
            'description' => __('remove close button from countdown sales notification', 'webforia-shop-booster'),
            'section' => $section,
            'default' => true,
            'active_callback' => [
                [
                    'setting' => 'sales_notif',
                    'operator' => '==',
                    'value' => true,
                ],
            ],
        ]);

    }

}

new Customizer;
