<?php
namespace Webforia_Shop_Booster;

class Countdown
{
    public function __construct()
    {

        add_action('wp_enqueue_scripts', [$this, 'scripts']);
        add_action('woocommerce_after_shop_loop_item_title', [$this, 'shop_countdown'], 15);
        add_action('woocommerce_single_product_summary', [$this, 'render'], 25);
    }

    /**
     * Ajax Scripts
     *
     * @return void
     */
    public function scripts()
    {
        if(wsb_option('countdown_timer_shop', true)){
        wp_enqueue_script('retheme-countdown', WEBFORIA_SHOP_BOOSTER_ASSETS . 'assets/js/countdown.min.js', false, '2.0.0', true);
    }
    }

   /**
    * Shop Countdown
    *
    * @hook action woocommerce_after_shop_loop_item_title
    * @return void
    */
    public function shop_countdown()
    {
        if (wsb_option('countdown_timer_shop', true)) {
            wsb_get_template_part('shop-countdown');
        }
    }

    /**
     * Single Countdown
     *
     * Show countodwn on product page
     * @hook action woocommerce_single_product_summary 25
     * @return void
     */
    public function render()
    {
        if (wsb_option('countdown_timer', true)) {
            wsb_get_template_part('product-countdown');

        }

    }

}
new Countdown;
