<?php
/*=================================================;
/* GET TEMPLATE
/*================================================= */
function wsb_get_template_part($template, $data = '')
{
    $loader = new WSB_Template_Loader;

    $loader->set_template_data($data)
        ->get_template_part($template);

}

/*=================================================;
/* GET OPTIONS
/*================================================= */
function wsb_option($value, $default = ''){
    return rt_option($value, $default);
}

/*=================================================;
/* GET PRODUCT ID
/*================================================= */
function wsb_get_product_id()
{
    global $product;

    $product_parent = wc_get_product($product->get_id());

    $product_variables = $product_parent->get_children();

    if ($product->is_type('variable')) {
        foreach ($product_variables as $key => $product_variable) {
            $product_id[] = $product_variable;
        }
    } else {
        $product_id[] = $product->get_id();
    }

    return $product_id;

}


/*=================================================
 * ORDER - CHECK ORDER COUNT
=================================================== */
function wsb_check_order()
{
    $args = array(
        'status' => 'completed',
        'limit' => 1,
    );

    $orders = wc_get_orders($args);

    return !empty($orders) ? true : false;
}

/*=================================================;
/* GET PRODUCT SALE DATE
/*================================================= 
* get product date sale from product 
* get product date sale form first product variation 
* deadline date sale each product variation required
*/
function wsb_product_get_sale_date()
{   
    $product = wc_get_product(get_the_ID());
    $productID = get_the_ID();
    $dateNow = date("Y/m/d");

    // get first product id form variation
    if ( $product->is_type('variable')) {
        $productID = current($product->get_children());
    }

    // get product object from the new id
    $the_product = wc_get_product($productID);

    // get deadline price sale
    $deadline = date('Y/m/d', strtotime($the_product->get_date_on_sale_to(). "+1 days"));

    // check product date and sale
    if (!empty($the_product->get_date_on_sale_to()) && $deadline >= $dateNow && $the_product->is_on_sale()) {
        return $deadline;
    }


}


/*=================================================
* GET ORDER BY PRODUCT
=================================================== */
function wsb_get_orders_ids_by_product_id( $product_id, $order_status = array( 'wc-completed' ) ){
    global $wpdb;

    $results = $wpdb->get_col("
        SELECT order_items.order_id
        FROM {$wpdb->prefix}woocommerce_order_items as order_items
        LEFT JOIN {$wpdb->prefix}woocommerce_order_itemmeta as order_item_meta ON order_items.order_item_id = order_item_meta.order_item_id
        LEFT JOIN {$wpdb->posts} AS posts ON order_items.order_id = posts.ID
        WHERE posts.post_type = 'shop_order'
        AND posts.post_status IN ( '" . implode( "','", $order_status ) . "' )
        AND order_items.order_item_type = 'line_item'
        AND order_item_meta.meta_key = '_product_id'
        AND order_item_meta.meta_value = '$product_id'
    ");

    return $results;
}